% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{mT.fillAges}
\alias{mT.fillAges}
\title{Restrict/expand a mortalityTable to certain ages}
\usage{
mT.fillAges(table, neededAges, fill = 0)
}
\arguments{
\item{table}{A life table object (instance of a \code{mortalityTable} class) or a list, table or array of mortalityTable objects}

\item{neededAges}{The vector of ages the returned objects should cover (even if the values are 0 or NA)}

\item{fill}{The value to use for all ages for which the original table(s) do not have any information}
}
\description{
Restrict the given \code{mortalityTable} object(s) to given ages, potentially filling with NA values to ensure they cover the full desired age range
}
\examples{
mortalityTables.load("Austria_Annuities")
# return a table with only ages 100-130, where ages above 120 (not defined
# in the original table) are filled with qx=1:
mT.fillAges(AVOe2005R.male, neededAges = 100:130, fill = 1)

}
