% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplusModel.R
\name{expandCmd}
\alias{expandCmd}
\title{Expand Mplus-style hyphenated variable ranges}
\usage{
expandCmd(cmd, expand_numeric = FALSE)
}
\arguments{
\item{cmd}{A single character string containing Mplus syntax to expand.}

\item{expand_numeric}{Logical. If \code{TRUE}, expand pure numeric ranges
(e.g., \code{1-3} -> \verb{1 2 3}) in list-like contexts. Default: \code{FALSE}.}
}
\value{
A character string with hyphenated ranges expanded to explicit
variable lists.
}
\description{
Expands Mplus shorthand expressions that specify sequences of variables
using hyphenated ranges (e.g., \code{y1-y3}) into the full list of
variables (e.g., \code{y1 y2 y3}). This function also propagates suffixes
from the right-hand token (e.g., \code{@c}, \code{*c}, or bare \code{*})
to every expanded variable (e.g., \verb{y1-y3@1} -> \verb{y1@1 y2@1 y3@1}).
}
\details{
By default, the function does \strong{not} expand pure numeric ranges (e.g.,
\code{1-3}) to avoid confusion with arithmetic subtraction. If
\code{expand_numeric = TRUE}, such ranges will be expanded when they
appear in list-like contexts (whitespace/comma/semicolon/parentheses
boundaries) and the line does not contain an equals sign (to avoid
accidental expansion of arithmetic like \code{d = 1 - 3}).

Hyphens in \code{MODEL CONSTRAINT} expressions such as
\code{a = b1-b2} are explicitly protected and left untouched.
}
\examples{
\dontrun{
expandCmd("y1-y3 y5-y6")
# "y1 y2 y3 y5 y6"

expandCmd("BY y1-y3@0.5;")
# "BY y1@0.5 y2@0.5 y3@0.5;"

expandCmd("z10-z12*2")
# "z10*2 z11*2 z12*2"

expandCmd("MODEL CONSTRAINT: a = b1-b2;")
# "MODEL CONSTRAINT: a = b1-b2;" (unchanged)

expandCmd("1 - 3", expand_numeric = TRUE)
# "1 2 3"

expandCmd("d = 1 - 3;", expand_numeric = TRUE)
# "d = 1 - 3;" (unchanged because of '=')
}
}
\keyword{internal}
