% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOpt.R
\name{JordanMat}
\alias{JordanMat}
\title{Convert a Matrix to Jordan-Like Form for Term Structure Models}
\usage{
JordanMat(matrix_in)
}
\arguments{
\item{matrix_in}{squared matrix prior to Jordan form}
}
\value{
A matrix in a specialized block form used in term structure modeling
}
\description{
Convert a Matrix to Jordan-Like Form for Term Structure Models
}
\references{
\itemize{
  \item The mathematical approach is based on methods described in:
  Dai, Q., & Singleton, K. J. (2000). Specification Analysis of Affine
  Term Structure Models. The Journal of Finance, 55(5), 1943-1978.

  \item Le, A., & Singleton, K. J. (2018). Small Package of Matlab Routines for
  Estimation of Some Term Structure Models. EABCN Training School.

  \item For theoretical background on Jordan forms in term structure models:
  Duffee, G. R. (2002). Term Premia and Interest Rate Forecasts in Affine
  Models. The Journal of Finance, 57(1), 405-443.
}
}
\keyword{internal}
