% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata.R
\name{gendata_simu_multi2}
\alias{gendata_simu_multi2}
\title{Generate simulated data}
\usage{
gendata_simu_multi2(
  seed = 1,
  nvec = c(100, 300),
  a_interval = c(0, 1),
  p = 50,
  d = 3,
  q = 3,
  qs = rep(2, length(nvec)),
  rank0 = 3,
  rho = c(rhoA = 1, rhoB = 1, rhoZ = 1),
  sigma2_eps = 1,
  seed.beta = 1
)
}
\arguments{
\item{seed}{a postive integer, the random seed for reproducibility of data generation process.}

\item{nvec}{a  vector with postive integers, specify the sample size in each study/source.}

\item{a_interval}{a numeric vector with two elements, specify the range of offset term values in each study.}

\item{p}{a postive integer, specify the dimension of count variables.}

\item{d}{a postive integer,  specify the dimension of covariate matrix.}

\item{q}{a postive integer,  specify the number of study-shared factors.}

\item{qs}{a  vector with postive integers, specify the number of study-specified factors.}

\item{rank0}{a postive integer, specify the rank of the coefficient matrix.}

\item{rho}{a numeric vector with length 3 and positive elements, specify the signal strength of regression coefficient and loading matrices, respectively.}

\item{sigma2_eps}{a positive real, the variance of overdispersion error.}

\item{seed.beta}{a postive integer, the random seed for fixing the regression coefficient matrix and loading matrix generation.}
}
\value{
return a list including the following components: 
(1) Xlist, the list consisting of high-dimensional count matrices from multiple studies; (2) aList: the known normalization term (offset) for each study; (3) Zlist, the list consisting of covariate matrix;
(4) bbeta0, the true regression coefficient matrix; (5) A0, the loading matrix of study-shared factors;  (6) Blist, the list consisting of loading matrices of study-specified factors;
(7)lambdavec, the variance vector of the random error vector; (8)Flist, the list composed by study-shared factor matrices; (9) Hlist, the list composed by study-specified factor matrices; 
(10) rank0, the rank of underlying regression coefficient matrix;  (11) q, the number of study-shared factors; (12)qs, the numbers of study-specified factors.
}
\description{
Generate simulated data from covariate-augmented Poisson factor models
}
\details{
None
}
\examples{
seed <- 1; nvec <- c(100,300); p<- 300;
d <- 3; q<- 3; qs <- rep(2,2)
datlist <- gendata_simu_multi2(seed=seed, nvec=nvec, p=p, d=d, q=3, qs=qs)
str(datlist)
}
\references{
None
}
\seealso{
None
}
