% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findcrit.r
\name{findcrit}
\alias{findcrit}
\title{Calculate critical values}
\usage{
findcrit(
  salpha = c(0.01, 0.02, 0.025),
  smatrix = diag(3),
  sided = 1,
  tol = 1e-10,
  alpha.tol = 1e-11
)
}
\arguments{
\item{salpha}{Numeric vector of cumulative alpha levels.}

\item{smatrix}{General correlation matrix.}

\item{sided}{Integer vector indicating the side of the test:
\itemize{
\item \code{-1}: Reject if test statistic is smaller than or equal to the critical value (one-sided)
\item \code{1}: Reject if test statistic is greater or equal to the critical value (one-sided)
\item \code{0}: Reject if the absolute value of the test statistic is greater than the critical value (two-sided)
}}

\item{tol}{Numeric scalar with the tolerance level for computing
critical values.}

\item{alpha.tol}{Numeric scalar. If the alpha increment is less than this,
the critical value is set to a large number determined by \code{alpha.tol}.}
}
\value{
List with element \code{crit.value} containing the obtained critical values.
}
\description{
\code{findcirt()} calculates the critical values in the general correlation matrix
}
\examples{
findcrit(
  salpha = c(0.01, 0.02, 0.025),
  smatrix = diag(3),
  sided = 1,
  tol = 1e-10,
  alpha.tol = 1e-11
)
}
\author{
Xiaodong Luo
}
\concept{critical values}
\concept{efficacy boundary}
\concept{group-sequential}
