% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqqvalhh.r
\name{seqqvalhh}
\alias{seqqvalhh}
\title{Sequential generalized Hochberg and Hommel procedures based on q-values}
\usage{
seqqvalhh(
  pm = matrix(rep(c(0.03, 0.04, 0.01), times = 2), ncol = 3, nrow = 2),
  alpham = matrix(rep(c(0.02, 0.03, 0.05), each = 2), ncol = 3, nrow = 2),
  epsilon = 1e-10,
  precision = 10,
  method = "Hochberg"
)
}
\arguments{
\item{pm}{Matrix of group-sequential p-values for different hypotheses (in row)
at different times (in column).}

\item{alpham}{Matrix of alpha spending corresponding to the p-values \code{pm}.
For each row, alpha levels must be non-decreasing.}

\item{epsilon}{Numeric scalar indicating the lower bound for alpha.}

\item{precision}{Integer scalar for precision of the values, obsolete for
backward compatibility.}

\item{method}{Character scalar "Hochberg" or "Hommel".}
}
\value{
List with elements
\itemize{
\item \code{rejected}: the index set of rejected hypotheses
\item \code{decisionsm}: rejection decision for each endpoint (row) at each
timepoint (column)
\item \code{cumdecisionsm}: cumulative rejection decision for each endpoint (row) at
each timepoint (column);
\item \code{alphaused}: alpha levels actually used for each endpoint (row) at each
timepoint (column).
}
}
\description{
Sequential generalized Hochberg and Hommel procedures based on q-values
}
\examples{
pm <- matrix(rep(c(0.03, 0.04, 0.01), times = 2), ncol = 3, nrow = 2)
alpham <- matrix(rep(c(0.02, 0.03, 0.05), each = 2), ncol = 3, nrow = 2)
seqqvalhh(pm = pm, alpham = alpham, method = "Hochberg")
seqqvalhh(pm = pm, alpham = alpham, method = "Hommel")
}
\author{
Xiaodong Luo
}
\concept{Hochberg procedure}
\concept{Hommel procedure}
\concept{group-sequential}
\concept{q-values}
