% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NADA_summary.R
\name{cenxyplot}
\alias{cenxyplot}
\title{Produces a censored x-y scatter plot}
\usage{
cenxyplot(x, xcen, y, ycen, log = "", lty = "dashed", ...)
}
\arguments{
\item{x}{A numeric vector of observations.}

\item{xcen}{A logical vector indicating TRUE where an observation in \code{x} is
censored (a less-than value) and FALSE otherwise.}

\item{y}{A numeric vector of observations.}

\item{ycen}{A logical vector indicating TRUE where an observation in \code{y} is
censored (a less-than value) and FALSE otherwise.}

\item{log}{A character string specifying which axes are logarithmic:
\code{"x"} for x-axis, \code{"y"} for y-axis, \code{"xy"} or \code{"yx"} for both axes,
or \code{""} for none (default).}

\item{lty}{The line type for the lines representing censored-data ranges.}

\item{...}{Additional arguments passed to \code{\link[graphics:plot.default]{graphics::plot()}}.}
}
\description{
Draws an x-y scatter plot with censored values represented by
dashed lines spanning from the censored threshold to zero.
}
\references{
Helsel, Dennis R. (2005). \emph{Nondetects and Data Analysis; Statistics for
censored environmental data.} John Wiley and Sons, Hoboken, NJ.
}
