% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmColorMap}
\alias{chmColorMap}
\title{Get the color map of an NG-CHM object.}
\usage{
chmColorMap(x)
}
\arguments{
\item{x}{The NG-CHM object to get the color map of.  Can be:
\itemize{
\item An object of class ngchmLayer
\item An object of class ngchmBar
\item An object of class ngchmCovariate
}}
}
\value{
An ngchmColormap
}
\description{
Get the color map of an NG-CHM object.
}
\examples{
# If the NGCHMDemoData package is installed, use it to demo usage
if (requireNamespace("NGCHMDemoData", quietly = TRUE)) {
  data(TCGA.GBM.EXPR, package = "NGCHMDemoData")
  colormap <- chmColorMap(chmNewDataLayer("New layer", TCGA.GBM.EXPR[1:3, 1:3]))
}
matrix <- matrix(rnorm(100),
  nrow = 10, ncol = 10,
  dimnames = list(paste0("r", 1:10), paste0("c", 1:10))
)
colormap <- chmColorMap(chmNewDataLayer("New layer", matrix))

}
\seealso{
\link{chmNewColorMap}
}
