% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmNewServer}
\alias{chmNewServer}
\title{Create a new object representing a NGCHM server.}
\usage{
chmNewServer(
  serverName,
  serverPort = 8080,
  deployServer = NULL,
  protoOpts = NULL,
  jarFile = NULL,
  serverURL = NULL
)
}
\arguments{
\item{serverName}{The DNS name of the NGCHM server.}

\item{serverPort}{The port on which the server is listening.}

\item{deployServer}{The DNS name to use when deploying a NGCHM (defaults to serverName).}

\item{protoOpts}{A list of protocol-specific parameters}

\item{jarFile}{The location of the heatmap build jar file to use when making a NGCHM (defaults to jar file on serverURL WS).}

\item{serverURL}{The URL used to access the NGCHM server (defaults to serverName:serverPort/chm).}
}
\value{
An object of class ngchmServer
}
\description{
This function creates a new object that represents a NGCHM server.
}
\examples{
cloudServ <- chmNewServer("dnsname.domain")

}
\seealso{
\linkS4class{ngchmServer}

\code{\link[=chmInstall]{chmInstall()}}

\code{\link[=chmUninstall]{chmUninstall()}}
}
