% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmRegisterMatrixFunction}
\alias{chmRegisterMatrixFunction}
\title{Register a predefined Javascript function for use in NGCHM Matrix menus.}
\usage{
chmRegisterMatrixFunction(rowtype, columntype, label, fn)
}
\arguments{
\item{rowtype}{A character vector specifying the row type(s) of the matrix function.}

\item{columntype}{A character vector specifying the column type(s) of the
matrix function.}

\item{label}{A single character string specifying the label of the matrix function.}

\item{fn}{The function to be registered. This can be either a function or a
character string representing the name of a function.}
}
\value{
None. This function is used for its side effects of registering a new
function in the NGCHM matrix menues.
}
\description{
This function registers a Javascript function that will be automatically
added to the matrix menu when building a Next Generation
Clustered Heat Map for matrices whose rows and columns match then function's
axes types.
This function is intended for use by NGCHM system developers.
}
\seealso{
\code{\link[=chmAddAxisType]{chmAddAxisType()}}

\code{\link[=chmRegisterAxisFunction]{chmRegisterAxisFunction()}}

\code{\link[=chmRegisterTypeMapper]{chmRegisterTypeMapper()}}

\code{\link[=chmNewFunction]{chmNewFunction()}}
}
