% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{addSelection}
\alias{addSelection}
\title{Add a selection}
\usage{
addSelection(NGLVieweR_proxy, type, param = list(), structureIndex = NULL)
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{type}{Type of representation. Most common options are "cartoon",
"ball+stick", "surface", "ribbon" and "label".}

\item{param}{Options for the different types of representations. Most common
options are \code{name}, \code{opacity}, \code{colorScheme}, \code{sele},
\code{colorValue} and \code{visibility}. For a full list of options, see the
general "RepresentationParameters" method and type specific Label-,
Structure- and Surface- RepresentationParameters in the official
\href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}

\item{structureIndex}{(optional) The index of the specific structure to which
the selection should be added (index 0 for the first). If not specified, the
selection will be applied to all loaded structures.}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message
parameters.
}
\description{
Add a new selection to a NGLVieweR object in Shinymode.
}
\examples{
\dontrun{
NGLVieweR_proxy("7CID") \%>\%
 addSelection("ball+stick", param = list(name="sel1",
                                         sele="1-20",
                                         colorValue="yellow",
                                         colorScheme="element"
                                         ))
}

if (interactive()) {
library(shiny)

ui <- fluidPage(
  titlePanel("Viewer with API inputs"),
  sidebarLayout(
    sidebarPanel(
      textInput("selection", "Selection", "1-20"),
      selectInput("type", "Type", c("ball+stick", "cartoon", "backbone")),
      selectInput("color", "Color", c("orange", "grey", "white")),
      actionButton("add", "Add"),
      actionButton("remove", "Remove")
    ),
    mainPanel(
      NGLVieweROutput("structure")
    )
  )
)
server <- function(input, output) {
  output$structure <- renderNGLVieweR({
    NGLVieweR("7CID") \%>\%
      addRepresentation("cartoon",
        param = list(name = "cartoon", colorScheme = "residueindex")
      )
  })
  observeEvent(input$add, {
    NGLVieweR_proxy("structure") \%>\%
      addSelection(isolate(input$type),
        param =
          list(
            name = "sel1",
            sele = isolate(input$selection),
            colorValue = isolate(input$color)
          )
      )
  })

  observeEvent(input$remove, {
    NGLVieweR_proxy("structure") \%>\%
      removeSelection("sel1")
  })
}
shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=updateRepresentation]{updateRepresentation()}} Update an existing NGLVieweR representation.
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "addSelection".
}

Other selections: 
\code{\link{removeSelection}()},
\code{\link{updateSelection}()}
}
\concept{selections}
