% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{updateSelection}
\alias{updateSelection}
\title{Update a selection}
\usage{
updateSelection(NGLVieweR_proxy, name = name, sele = "none")
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{name}{Name of selection.}

\item{sele}{Selected atoms/residues. See the section "selection-language" in
the official \href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message
parameters.
}
\description{
Update the selected residues of an existing NGLVieweR selection
in
}
\examples{
\dontrun{
NGLVieweR_proxy("structure") \%>\%
  updateSelection("ball+stick", sele = "1-20")
}

if (interactive()) {
  library(shiny)
  ui <- fluidPage(
    titlePanel("Viewer with API inputs"),
    sidebarLayout(
      sidebarPanel(
        textInput("selection", "Selection", "1-20"),
        actionButton("update", "Update")
      ),
      mainPanel(
        NGLVieweROutput("structure")
      )
    )
  )
  server <- function(input, output) {
    output$structure <- renderNGLVieweR({
      NGLVieweR("7CID") \%>\%
        addRepresentation("cartoon",
          param = list(name = "cartoon", color = "red")
        ) \%>\%
        addRepresentation("ball+stick",
          param = list(
            name = "ball+stick",
            colorValue = "yellow",
            colorScheme = "element",
            sele = "1-20"
          )
        )
    })
    observeEvent(input$update, {
      NGLVieweR_proxy("structure") \%>\%
        updateSelection("ball+stick", sele = isolate(input$selection))
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "updateSelection".
}

Other selections: 
\code{\link{addSelection}()},
\code{\link{removeSelection}()}
}
\concept{selections}
