% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_waiting_list_pressure.R
\name{calc_waiting_list_pressure}
\alias{calc_waiting_list_pressure}
\title{Calculate Waiting List Pressure}
\usage{
calc_waiting_list_pressure(mean_wait, target_wait)
}
\arguments{
\item{mean_wait}{Numeric value of target mean waiting time to achieve a given
target wait.}

\item{target_wait}{Numeric value of the number of weeks that has been set as
the target within which the patient should be seen.}
}
\value{
Numeric value of wait_pressure which is the waiting list pressure.
}
\description{
For a waiting list with target waiting time, the pressure on the
waiting list is twice the mean delay divided by the waiting list target.
The pressure of any given waiting list should be less than 1. If the
pressure is greater than 1 then the waiting list is most likely going to
miss its target. The waiting list pressure is calculated as follows:
pressure = 2 * mean_wait / target_wait.
}
\examples{
calc_waiting_list_pressure(63, 52)
}
