% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.generate.R
\name{Q.generate}
\alias{Q.generate}
\title{Generation of dichotomous Q-matrix}
\usage{
Q.generate(K, J, p, single.att = TRUE)
}
\arguments{
\item{K}{The number of attributes.}

\item{J}{The number of items.}

\item{p}{The probability that each q-entry equals 1.}

\item{single.att}{Whether all the single-attribute patterns are included.
If \code{TRUE}, the completeness of the Q-matrix is guaranteed.}
}
\value{
The function returns a dichotomous Q-matrix. A complete Q-matrix is the default unless
\code{single.att = F} is specified.
}
\description{
The function generates a complete Q-matrix based on a
    pre-specified probability that each q-entry equals 1.
}
\examples{
\dontrun{
# Example 1: A complete Q-matrix with items requiring fewer attributes.
Q1 = Q.generate(3, 20, 0.5, single.att = TRUE)

# Example 2: A Q-matrix with items requiring more attributes but completeness is not guaranteed.
Q2 = Q.generate(5, 30, 0.6, single.att = FALSE)
}
}
\seealso{
\code{\link{Q.completeness}}
}
