% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_rate.R
\name{correction.rate}
\alias{correction.rate}
\title{Correction rate of a Q-matrix refinement method}
\usage{
correction.rate(ref.Q = ref.Q, mis.Q = mis.Q, true.Q = true.Q)
}
\arguments{
\item{ref.Q}{The \eqn{J \times K} refined binary Q-matrix.}

\item{mis.Q}{A \eqn{J \times K} binary provisional Q-matrix.}

\item{true.Q}{The \eqn{J \times K} binary true Q-matrix.}
}
\value{
The function returns a value between 0 and 1 representing the proportion of corrected q-entries in \code{ref.Q}
that were originally misspecified in \code{mis.Q}.
}
\description{
This function computes the proportion of corrected q-entries that
were originally misspecified in the provisional Q-matrix. This function is used
only when the true Q-matrix is known.
}
\examples{
# See examples used for QR function.
}
