% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distractor.check.R
\name{distractor.check}
\alias{distractor.check}
\title{Detect the implausible and improper distractors in a Q-Matrix for multiple-choice items}
\usage{
distractor.check(Q = Q, key = NULL)
}
\arguments{
\item{Q}{The given Q-matrix for multiple-choice items. It has to be organized in the following manner. The Q-matrix should contain \eqn{K+2} columns
and \eqn{J \times (H_j)} rows, where \eqn{H_j} is the number of coded options for item \eqn{j}. Among the \eqn{H_j} rows for item \eqn{j},
the first row is the key, followed by the coded distractors.
The first column of the Q-matrix lists the ID of the items and second column indicates the corresponding options of the coded options.
If the Q-matrix is not organized in such a way, an argument \code{key} (see below) that indicates the options that the keys
are located needs to be given.}

\item{key}{A vector that indicates the options where the keys are located.}
}
\value{
A list with class "distractor.check" containing:
\describe{
  \item{not.plausible}{A matrix indicating items and options that are not plausible, or NULL if all items are plausible.}
  \item{not.proper}{A vector of item IDs that are not proper, or NULL if all items are proper.}
  \item{all.plausible}{Logical; TRUE if all items are plausible.}
  \item{all.proper}{Logical; TRUE if all items are proper.}
}
}
\description{
Function \code{distractor.check} is used to assess whether the distractors of a given Q-matrix for multiple-choice items are plausible and/or proper.
}
\examples{
\dontrun{
library(NPCDTools)
Q1 <- Q_Ozaki
distractor.check(Q1)

Q2 <- GDINA::sim10MCDINA2$simQ
key <- c(1, 2, 4, 1, 1, 3, 2, 4, 1, 4)
distractor.check(Q2, key)
}

}
\references{
Chiu, C.-Y., Köhn, H. F. & Wang, Y. (Online first). Plausible and proper
multiple-choice items for diagnostic classification. \emph{Psychometrika}.
}
