% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.GNPC}
\alias{plot.GNPC}
\title{Plot Diagnostics for GNPC}
\usage{
\method{plot}{GNPC}(
  x,
  type = c("convergence", "individual"),
  examinee.id = NULL,
  true.alpha = NULL,
  top.n.pattern = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"GNPC"} when \code{track.convergence = TRUE}.}

\item{type}{\code{"convergence"} (default) for overall convergence diagnostics,
or \code{"individual"} for a single examinee's estimation trajectory.}

\item{examinee.id}{An integer indicating which examinee to be plotted. This argument is required 
if \code{"individual"} is specified.}

\item{true.alpha}{A numeric vector of length \eqn{K}{} when the true attribute profile
of the examinee is available (optional; usually used for simulation studies).}

\item{top.n.pattern}{An integer specifying the maximum number of patterns to be displayed.
The default is \code{min(2^K, 6)}. The GNPC estimate and true pattern
(if provided) are always included.}

\item{\dots}{Additional arguments passed to \code{\link{plot}}.}
}
\description{
This function gives two types of diagnostic plots for the outcomes of the GNPC algorithm. 

The type = "\code{convergence}" option gives two graphs: The upper panel displays the trajectory of the proportion of 
membership switches and the lower panel shows the total squared distance along with the iterations. 
They illustrate the detailed information about how and whether the 
algorithm has converged. 

The type = "\code{individual}" option returns a sequence of squared distances for a 
single examinee and the estimates of the examinee's attribute profile 
along with the iterations. The plots allow users to investigate how the algorithm
arrives at its final classifications. In simulation studies, the true
attribute profile can be provided as a reference.
}
\details{
For \code{"individual"} plots, the visual elements are:
\itemize{
  \item \strong{Red line}: the attribute pattern ultimately selected by GNPC.
  \item \strong{Black line}: the true attribute pattern (only when
    \code{true.alpha} is provided). A small vertical jitter is applied
    when it overlaps with the red line.
  \item \strong{Other colored lines}: the most competitive candidate
    patterns, selected by proximity at the final iteration.
  \item \strong{Filled circle at each iteration}: indicates which attribute profile
    GNPC assigned to the examinee at each iteration, drawn in the
    corresponding line's color. The line for the true attribute profile always has black
    circles at every iteration as a fixed reference.
}
}
\examples{
\dontrun{
library(GDINA)
set.seed(123)
N <- 500
Q <- sim30GDINA$simQ
gs <- data.frame(guess = rep(0.2, nrow(Q)), slip = rep(0.2, nrow(Q)))
sim <- simGDINA(N, Q, gs.parm = gs, model = "DINA")
Y <- extract(sim, what = "dat")
alpha <- extract(sim, what = "attribute")

# Analyze data using GNPC
result <- GNPC(Y, Q, initial.dis = "hamming", initial.gate = "AND")

# Convergence
plot(result)

# Individual with true attribute profile (simulation)
plot(result, type = "individual", examinee.id = 1, true.alpha = alpha[1, ])

# Individual without true attribute profile (real data)
plot(result, type = "individual", examinee.id = 1)
}

}
\seealso{
\code{\link{GNPC}}
}
