% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retention_rate.R
\name{retention.rate}
\alias{retention.rate}
\title{Retention rate of a Q-matrix refinement method}
\usage{
retention.rate(ref.Q = ref.Q, mis.Q = mis.Q, true.Q = true.Q)
}
\arguments{
\item{ref.Q}{The \eqn{J \times K} refined binary Q-matrix.}

\item{mis.Q}{A \eqn{J \times K} binary provisional Q-matrix.}

\item{true.Q}{The \eqn{J \times K} binary true Q-matrix.}
}
\value{
The function returns a value between 0 and 1 indicating the proportion of
correctly specified q-entries in \code{mis.Q} that remain correctly specified in \code{ref.Q}
after a Q-matrix refinement procedure is applied to \code{mis.Q}.
}
\description{
This function computes the proportion of correctly specified q-entries
in a provisional Q-matrix that remain correctly specified after a Q-matrix refinement
procedure is applied. This function is used only when the true Q-matrix is known.
}
\seealso{
See examples used for \code{\link{QR}}.
}
