#' Calculate N derived from Fertilizer (NdfF)
#' @description
#' The percentage of plant or soil N that is derived from the fertilizer.
#' Formula: NdfF = (Plant15N / Fert15N) * 100
#' @param Plant15N A vector of 15N atom percent excess in plant or soil.
#' @param Fert15N 15N atom percent excess of fertilizer N.
#' @return A numeric vector of NdfF percentages.
#' @examples
#' Plant15N <- c(0.4, 0.5)
#' Fert15N <- 2.5
#' NdfF(Plant15N, Fert15N)
#' @export
NdfF <- function(Plant15N, Fert15N) {
  if (any(Fert15N == 0)) stop("Fert15N cannot be zero.")
  return((Plant15N / Fert15N) * 100) # Note: Often expressed as ratio, check if 100 needed based on usage
}