#' Calculate Virtual N Factor (VNF)
#' @description
#' The portion of N released to the environment not contained in food.
#' Formula: VNF = Nrec / Ncon
#' @param Nrec N used to produce food item that ends up recycled.
#' @param Ncon N in food item that is consumed.
#' @return A numeric vector of VNF values.
#' @examples
#' Nrec <- c(10, 12)
#' Ncon <- c(40, 45)
#' VNF(Nrec, Ncon)
#' @export
VNF <- function(Nrec, Ncon) {
  return(Nrec / Ncon)
}