% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PE.R
\name{PE}
\alias{PE}
\title{Calculate Physiological Efficiency (PE)}
\usage{
PE(YieldF, Yield0, PlantNf, PlantN0)
}
\arguments{
\item{YieldF}{A numeric vector of final yield values.}

\item{Yield0}{A numeric vector of non-fertilized control yield values.}

\item{PlantNf}{A numeric vector of plant N at the end of the experiment.}

\item{PlantN0}{A numeric vector of plant N at the beginning/control.}
}
\value{
A numeric vector of PE values.
}
\description{
The contribution of fertilizer N from the plant tissues towards the yield component.
Formula: PE = (YieldF - Yield0) / (PlantNf - PlantN0)
}
\examples{
YieldF <- c(12, 13, 14)
Yield0 <- c(10, 10, 10)
PlantNf <- c(3.5, 4.0, 4.2)
PlantN0 <- c(2.0, 2.0, 2.0)
PE(YieldF, Yield0, PlantNf, PlantN0)
}
