% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuss.R
\name{nuss}
\alias{nuss}
\title{Mixed N-Grams and Unigram Sequence Segmentation (NUSS) function}
\usage{
nuss(sequences, texts)
}
\arguments{
\item{sequences}{character vector, sequence to be segmented,
(e.g., hashtag) or without it. Case-insensitive.}

\item{texts}{character vector, these are the texts used to create n-grams
and unigram dictionary. Case-insensitive.}
}
\value{
The output always will be data.frame with sequences, that were
\cr \strong{The output is not in the input order. If needed, use
\link[base]{lapply}}
}
\description{
\code{nuss} returns the data.frame containing
hashtag, its segmented version, ids of dictionary words,
number of words it have taken to segment the hashtag,
total number of points, and computed score.
}
\details{
This function is an arbitrary combination of \link{ngrams_dictionary},
\link{unigram_dictionary}, \link{ngrams_segmentation},
\link{unigram_sequence_segmentation}, created to easily segment short texts
based on text corpus.
}
\examples{
texts <- c("this is science",
           "science is #fascinatingthing",
           "this is a scientific approach",
           "science is everywhere",
           "the beauty of science")
nuss(c("thisisscience", "scienceisscience"), texts)

}
