% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentMatrix-Class-methods.R
\docType{methods}
\name{bbox}
\alias{bbox}
\alias{bbox,agentMatrix-method}
\alias{bbox,ANY-method}
\alias{bbox<-}
\alias{bbox<-,agentMatrix,matrix-method}
\alias{bbox,worldNLR-method}
\alias{bbox,SpatExtent-method}
\title{Extract or set bounding box}
\usage{
bbox(obj)

\S4method{bbox}{agentMatrix}(obj)

\S4method{bbox}{ANY}(obj)

bbox(obj) <- value

\S4method{bbox}{agentMatrix,matrix}(obj) <- value

\S4method{bbox}{worldNLR}(obj)

\S4method{bbox}{SpatExtent}(obj)
}
\arguments{
\item{obj}{object deriving from class \code{agentMatrix},
or for \code{bbox} and \code{extent}, a \code{worldMatrix} or \code{worldArray}}

\item{value}{2x2 matrix representing the bounding box. See \code{sp::bbox}.}
}
\value{
The replacement method returns the same object as supplied to
obj, i.e., an \code{agentMatrix}, with the \code{bbox} attribute set to \code{value}.
}
\description{
Methods for classes in \code{NetLogoR} (i.e., \code{agentMatrix}, \code{worldMatrix}, and \code{worldArray}).

Replacement method sets the bbox attribute of an \code{agentMatrix}.
}
\examples{
newAgent <- agentMatrix(
  coords = cbind(pxcor = c(1, 2, 5), pycor = c(3, 4, 6)),
  char = letters[c(1, 2, 6)],
  nums2 = c(4.5, 2.6, 2343),
  char2 = LETTERS[c(4, 24, 3)],
  nums = 5:7
)
bbox(newAgent)
extent(newAgent)
coordinates(newAgent)
}
\seealso{
\code{\link[raster:extent]{raster::extent()}}, \code{\link[raster:xyFromCell]{raster::coordinates()}}, \code{\link[sp:bbox]{sp::bbox()}}
}
