% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlicecdLogNormalPareto.R
\name{qSlicedLNormPareto}
\alias{qSlicedLNormPareto}
\title{The inverse cumulative density function of a Sliced LogNormal Pareto severity distribution}
\usage{
qSlicedLNormPareto(q, mu, sigma, SlicePoint, shape)
}
\arguments{
\item{q}{A real number between 0 and 1 -  the probability where the inverse cumulative density function will be evaluated.}

\item{mu}{A real number -  the first parameter of the attritional Claim Severity's LogNormal distribution.}

\item{sigma}{A positive real number -  the second parameter of the attritional Claim Severity's LogNormal distribution.}

\item{SlicePoint}{A positive real number - the slice point and the scale parameter of the tail Claim Severity's Pareto distribution.}

\item{shape}{A positive real number - the shape parameter of the tail Claim Severity's Pareto distribution.}
}
\value{
The value of the inverse cumulative density function at \code{q} with an attritional claim LogNormal distribution with parameters \code{mu} and \code{sigma} and a large claim Pareto distribution with parameters \code{SlicePoint} and \code{shape}.
}
\description{
The inverse cumulative density function of a Sliced LogNormal Pareto severity distribution
}
\examples{
qSlicedLNormPareto(0.5,6,1.5,1000,1.2)
qSlicedLNormPareto(0.7,7,1.6,3000,1.4)
}
