% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvExpPower.r
\name{InvExpPower}
\alias{InvExpPower}
\alias{dinv.exp.power}
\alias{pinv.exp.power}
\alias{qinv.exp.power}
\alias{rinv.exp.power}
\alias{hinv.exp.power}
\title{Inverse Exponential Power Distribution}
\usage{
dinv.exp.power(x, alpha, lambda, log = FALSE)
pinv.exp.power(q, alpha, lambda, lower.tail = TRUE, log.p = FALSE)
qinv.exp.power(p, alpha, lambda, lower.tail = TRUE, log.p = FALSE)
rinv.exp.power(n, alpha, lambda)
hinv.exp.power(x, alpha, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dinv.exp.power}: numeric vector of (log-)densities
  \item \code{pinv.exp.power}: numeric vector of probabilities
  \item \code{qinv.exp.power}: numeric vector of quantiles
  \item \code{rinv.exp.power}: numeric vector of random variates
  \item \code{hinv.exp.power}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Inverse Exponential Power distribution.
}
\details{
The Inverse Exponential Power distribution is parameterized by the parameters
\eqn{\alpha > 0} and \eqn{\lambda > 0}.


The Inverse Exponential Power distribution has CDF:

\deqn{
F(x; \alpha, \lambda) =
\quad \exp \left\{1-\exp \left(\frac{\lambda}{x}\right)^\alpha\right\} 
\, ; \quad x > 0.
}

where \eqn{\alpha} and \eqn{\lambda} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dinv.exp.power()} — Density function
  \item \code{pinv.exp.power()} — Distribution function
  \item \code{qinv.exp.power()} — Quantile function
  \item \code{rinv.exp.power()} — Random generation
  \item \code{hinv.exp.power()} — Hazard function
}
}
\examples{
x <- seq(1.0, 5.0, 0.2)
dinv.exp.power(x, 2.5, 0.5)
pinv.exp.power(x, 2.5, 0.5)
qinv.exp.power(0.5, 2.5, 0.5)
rinv.exp.power(10, 2.5, 0.5)
hinv.exp.power(x, 2.5, 0.5)

# Data
x <- relief
# ML estimates
params = list(alpha=2.8286, lambda=1.3346)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pinv.exp.power, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qinv.exp.power, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dinv.exp.power, pfun=pinv.exp.power, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary, A.K., Sapkota,L.P. & Kumar, V.(2023). 
Inverse Exponential Power distribution: Theory and Applications. 
\emph{International Journal of Mathematics, Statistics and Operations 
Research}, \bold{3(1)}, 175--185.
}
