% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvUBD.r
\name{InvUBD}
\alias{InvUBD}
\alias{dinv.ubd}
\alias{pinv.ubd}
\alias{qinv.ubd}
\alias{rinv.ubd}
\alias{hinv.ubd}
\title{Inverse Upside Down Bathtub-shaped Hazard Function Distribution}
\usage{
dinv.ubd(x, alpha, beta, lambda, log = FALSE)
pinv.ubd(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qinv.ubd(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rinv.ubd(n, alpha, beta, lambda)
hinv.ubd(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dinv.ubd}: numeric vector of (log-)densities
  \item \code{pinv.ubd}: numeric vector of probabilities
  \item \code{qinv.ubd}: numeric vector of quantiles
  \item \code{rinv.ubd}: numeric vector of random variates
  \item \code{hinv.ubd}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Inverse Upside Down Bathtub-shaped Hazard Function distribution.
}
\details{
The Inverse Upside Down Bathtub-shaped Hazard Function distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Inverse Upside Down Bathtub-shaped Hazard Function distribution has CDF:

\deqn{
F(x;\,\alpha,\beta,\lambda) = \, \exp \left[ {1 - {{\left( {1 + \lambda {x^{ - \beta }}} 
\right)}^\alpha }} \right], \quad x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The functions available are listed below:
\itemize{
  \item \code{dinv.ubd()} — Density function
  \item \code{pinv.ubd()} — Distribution function
  \item \code{qinv.ubd()} — Quantile function
  \item \code{rinv.ubd()} — Random generation
  \item \code{hinv.ubd()} — Hazard function
}
}
\examples{
x <- seq(0.1, 1, 0.1)
dinv.ubd(x, 1.5, 0.8, 2)
pinv.ubd(x, 1.5, 0.8, 2)
qinv.ubd(0.5, 1.5, 0.8, 2)
rinv.ubd(10, 1.5, 0.8, 2)
hinv.ubd(x, 1.5, 0.8, 2)

#Data
x <- rainfall
#ML Estimates    
params = list(alpha =0.1804, beta=4.3216, lambda=85.13)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pinv.ubd, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qinv.ubd, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dinv.ubd, pfun = pinv.ubd, plot=FALSE)
print.gofic(out)

}
\references{
Dimitrakopoulou, T., Adamidis, K., & Loukas, S.(2007). 
A liftime distribution with an upside down bathtub-shaped hazard function, 
\emph{IEEE Trans. on Reliab.}, \bold{56(2)}, 308--311. 

Joshi, R.K., & Kumar, V. (2018). 
Inverse Upside Down Bathtub-Shaped Hazard Function distribution: Theory
and Applications. \emph{Journal of National Academy of Mathematics}, \bold{32}, 6--20.
}
