% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonInvLomax.r
\name{PoissonInvLomax}
\alias{PoissonInvLomax}
\alias{dpois.inv.lomax}
\alias{ppois.inv.lomax}
\alias{qpois.inv.lomax}
\alias{rpois.inv.lomax}
\alias{hpois.inv.lomax}
\title{Poisson Inverse Lomax Distribution}
\usage{
dpois.inv.lomax(x, alpha, beta, lambda, log = FALSE)
ppois.inv.lomax(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.inv.lomax(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.inv.lomax(n, alpha, beta, lambda)
hpois.inv.lomax(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.inv.lomax}: numeric vector of (log-)densities
  \item \code{ppois.inv.lomax}: numeric vector of probabilities
  \item \code{qpois.inv.lomax}: numeric vector of quantiles
  \item \code{rpois.inv.lomax}: numeric vector of random variates
  \item \code{hpois.inv.lomax}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Poisson Inverse Lomax distribution.
}
\details{
The Poisson Inverse Lomax distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Poisson Inverse Lomax distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad \frac{1}{\left(1-e^{-\lambda}\right)}
\left[1-\exp \left\{-\lambda(1+\beta / x)^{-\alpha}\right\}\right]  \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The functions available are listed below:
\itemize{
  \item \code{dpois.inv.lomax()} — Density function
  \item \code{ppois.inv.lomax()} — Distribution function
  \item \code{qpois.inv.lomax()} — Quantile function
  \item \code{rpois.inv.lomax()} — Random generation
  \item \code{hpois.inv.lomax()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dpois.inv.lomax(x, 2.0, 0.5, 0.2)
ppois.inv.lomax(x, 2.0, 0.5, 0.2)
qpois.inv.lomax(0.5, 2.0, 0.5, 0.2)
rpois.inv.lomax(10, 2.0, 0.5, 0.2)
hpois.inv.lomax(x, 2.0, 0.5, 0.2)

# Data
x <- stress
# ML estimates
params = list(alpha=4.1507, beta=5.4091, lambda=80.5762)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.inv.lomax, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.inv.lomax, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dpois.inv.lomax, pfun=ppois.inv.lomax, plot=FALSE)
print.gofic(out)

}
\references{
Joshi, R.K., & Kumar, V. (2021).
Poisson Inverted Lomax Distribution: Properties and Applications. 
\emph{International Journal of Research in Engineering 
and Science (IJRES)}, \bold{9(1)}, 48--57.    

Chaudhary, A. K., & Kumar, V.(2021). 
The ArcTan Lomax Distribution with Properties and Applications. 
\emph{International Journal of Scientific Research in Science, Engineering and 
Technology(IJSRSET)}, \bold{8(1)}, 117--125. \doi{10.32628/IJSRSET218117}
}
