% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonNHE.r
\name{PoissonNHE}
\alias{PoissonNHE}
\alias{dpois.NHE}
\alias{ppois.NHE}
\alias{qpois.NHE}
\alias{rpois.NHE}
\alias{hpois.NHE}
\title{Poisson-NHE Distribution}
\usage{
dpois.NHE(x, alpha, beta, lambda, log = FALSE)
ppois.NHE(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.NHE(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.NHE(n, alpha, beta, lambda)
hpois.NHE(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.NHE}: numeric vector of (log-)densities
  \item \code{ppois.NHE}: numeric vector of probabilities
  \item \code{qpois.NHE}: numeric vector of quantiles
  \item \code{rpois.NHE}: numeric vector of random variates
  \item \code{hpois.NHE}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Poisson-NHE distribution.
}
\details{
The Poisson-NHE distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Poisson-NHE distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\frac{1-\exp \left(-\lambda \exp \left\{\left\{1-(1+\alpha x)
^\beta\right\}\right\}\right)}{\left(1-e^{-\lambda}\right)} \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dpois.NHE()} — Density function
  \item \code{ppois.NHE()} — Distribution function
  \item \code{qpois.NHE()} — Quantile function
  \item \code{rpois.NHE()} — Random generation
  \item \code{hpois.NHE()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dpois.NHE(x, 2.0, 0.5, 0.2)
ppois.NHE(x, 2.0, 0.5, 0.2)
qpois.NHE(0.5, 2.0, 0.5, 0.2)
rpois.NHE(10, 2.0, 0.5, 0.2)
hpois.NHE(x, 2.0, 0.5, 0.2)

# Data
x <- fibers63
# ML estimates
params = list(alpha=0.5038, beta=1.8272, lambda=53.4573)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.NHE, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.NHE, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dpois.NHE, pfun=ppois.NHE, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary,A.K., & Kumar, V.(2020).
Poisson NHE Distribution: Properties and Applications.
\emph{International Journal of Applied Research(IJAR)},
\bold{6(12)},399--409. \doi{10.22271/allresearch.2020.v6.i12f.8143}
}
