\name{fibers63}
\alias{fibers63}
\title{Strength of 63 Carbon Fibers at 10 mm Gauge Length}

\description{
Measurements of tensile strength (in gigapascals, GPa) for 63 single carbon
fibers tested at a gauge length of 10 mm. These data were originally reported
by Bader and Priest (1982) in their study of fibre and bundle strength in
hybrid composites.
}

\usage{
fibers63
}

\format{
A numeric vector of length 63 containing tensile strength measurements
(in GPa).
}

\value{
An object of class \code{"numeric"}.

The vector consists of 63 observed tensile strength measurements (in
gigapascals), each corresponding to an individual carbon fiber tested at a
gauge length of 10 mm. Each value represents the breaking strength of a single
fiber specimen. The dataset is commonly used in materials science and
reliability engineering for modeling strength distributions, assessing
variability, and fitting parametric lifetime or strength models.
}

\details{
The dataset contains tensile strength values for individual carbon fibers cut
to a gauge length of 10 mm. This dataset has been used extensively in materials
science and reliability studies for modeling strength distributions and
assessing variability in carbon fiber performance.

The data originate from the same experimental study that produced several
related carbon-fiber datasets (e.g., \code{fibers65}, \code{fibers69}).
}

\references{
Bader, M. G., & Priest, A. M. (1982). Statistical aspects of fibre and bundle
strength in hybrid composites.
\emph{Progress in Science and Engineering of Composites}, 1129--1136.
}

\examples{
data(fibers63)

summary(fibers63)

hist(
  fibers63,
  main = "Tensile Strength of Carbon Fibers (10 mm Gauge Length)",
  xlab = "Strength (GPa)"
)
}

\keyword{datasets}

