% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensMLP.R
\name{ChangeBootAlpha}
\alias{ChangeBootAlpha}
\title{Change significance of boot SensMLP Class}
\usage{
ChangeBootAlpha(x, boot.alpha)
}
\arguments{
\item{x}{\code{SensMLP} object created by \code{\link[NeuralSens]{SensAnalysisMLP}}}

\item{boot.alpha}{\code{float} significance level}
}
\value{
\code{SensMLP} object with changed significance level. All boot related
metrics are changed
}
\description{
For a SensMLP Class object, change the significance level of the statistical tests
}
\examples{
\donttest{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR

## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000


## TRAIN nnet NNET --------------------------------------------------------

set.seed(150)
nnetmod <- caret::train(DEM ~ .,
                 data = fdata.Reg.tr,
                 method = "nnet",
                 tuneGrid = expand.grid(size = c(1), decay = c(0.01)),
                 trControl = caret::trainControl(method="none"),
                 preProcess = c('center', 'scale'),
                 linout = FALSE,
                 trace = FALSE,
                 maxit = 300)
# Try SensAnalysisMLP
sens <- NeuralSens::SensAnalysisMLP(nnetmod, trData = fdata.Reg.tr,
                                    plot = FALSE, boot.R=2, output_name='DEM')
NeuralSens::ChangeBootAlpha(sens, boot.alpha=0.1)
}
}
