% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Park_Shintani_2016_unit_root.R
\name{Park_Shintani_2016_unit_root}
\alias{Park_Shintani_2016_unit_root}
\title{Park and Shintani(2012) nonlinear unit root test function}
\usage{
Park_Shintani_2016_unit_root(x, max_lags)
}
\arguments{
\item{x}{series name,}

\item{max_lags}{maximum lag (Apropriate lag is selected by Akaike Information Criteria)}
}
\value{
"Model" Estimated model

"Selected Lag" the lag order

"Test statistic" the value of the test statistic
}
\description{
This function allows you to make Park and Shintani(2012) nonlinear unit root test
}
\examples{

\donttest{
x <- rnorm(50)
Park_Shintani_2016_unit_root(x, max_lags = 1)

data(IBM)
Park_Shintani_2016_unit_root(IBM, max_lags = 12)

}


}
\references{
Park, J. Y., & Shintani, M. (2016). Testing for a unit root against transitional autoregressive models. International Economic Review, 57(2), 635-664.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
