% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAIA.r
\name{opiInitialise_for_MAIA}
\alias{opiInitialise_for_MAIA}
\title{Implementation of opiInitialise for the ImoVifa machine.}
\arguments{
\item{ip}{IP address on which server is listening as a string}

\item{port}{Port number on which server is listening}

\item{...}{Could be used for fake MAIA, simulations, etc}
}
\value{
A list with elements:
\itemize{
\item \code{err} NULL if successful, not otherwise.
}
}
\description{
This is for internal use only. Use \code{\link[=opiInitialise]{opiInitialise()}} with
these Arguments and you will get the Value back.
}
\details{
Establishes socket connection but sends not messages (see \code{opiSetup_for_MAIA}).
}
\examples{
\dontrun{
  # Set up the MAIA
  chooseOpi("MAIA")
  result <- opiInitialize(ip = "192.168.1.7", port = 5555)
  if (is.null(result$err))
    print(result$err)
}
}
