% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_density.R
\name{h_OSCV_dens}
\alias{h_OSCV_dens}
\title{The OSCV bandwidth in the density estimation context.}
\usage{
h_OSCV_dens(dat, stype)
}
\arguments{
\item{dat}{numerical vecror of data values,}

\item{stype}{specifies (anticipated) smoothness of the density function. Thus, \eqn{stype=0} corresponds to the \emph{smooth} density, whereas \eqn{stype=1} corresponds to the \emph{nonsmooth} density.}
}
\value{
The OSCV bandwidth (scalar).
}
\description{
Computing the OSCV bandwidth for the Gaussian density estimator. The one-sided Gaussian kernel \eqn{L_G} is used in the bandwidth selection stage. The (anticipated) smoothness of the density function is to be specified by the user.
}
\details{
Computing the OSCV bandwidth for the data vector \eqn{dat}. The one-sided Gaussian kernel \eqn{L_G} is used for the cross-validation purposes and the Gaussian kernel is used for computing the ultimate density estimate. The (anticipated) smoothness of the underlying density function is to be specified. Thus, \itemize{\item \eqn{stype=0} corresponds to the smooth density; \item \eqn{stype=1} corresponds to the nonsmooth density.} It is usually assumed that the density is smooth if no preliminary information about its nonsmoothness is available. No additional rescaling of the computed bandwidth is needed. The smoothness of the density function \eqn{stype}, essentially, determines the value of the bandwidth rescaling constant that is used in the body of the function. Thus, the constant is equal to 0.6168471 in the smooth case, whereas it is equal to 0.5730 in the nonsmooth case. See Savchuk (2017) for details. The OSCV bandwidth is the minimizer of the OSCV function \code{\link{OSCV_Gauss_dens}}.
}
\examples{
\dontrun{
data=faithful[,1]         # Data on n=272 eruption duration of the Old Faithful geyser.
harray=seq(0.025,0.6,len=100)
OSCV_array=OSCV_Gauss_dens(harray,data,0)
dev.new()
plot(harray,OSCV_array,lwd=3,'l',xlab="h",ylab="L_G-based OSCV",
main="OSCV_G(h) for the data on eruption duration",cex.main=1.5,cex.lab=1.7,cex.axis=1.7)
h_oscv=round(h_OSCV_dens(data,0),digits=4) #smoothness of the underlying density is assumed
legend(0.04,-0.25,legend=c("n=272",paste("h_OSCV=",h_oscv)),cex=2,bty="n")
}
}
\references{
Savchuk, O.Y. (2017). One-sided cross-validation for nonsmooth densty functions, arXiv:1703.05157.
}
\seealso{
\code{\link{OSCV_Gauss_dens}},  \code{\link{C_smooth}}, \code{\link{h_OSCV_reg}}.
}
