"jpn" <-
function(region, xlim = c(128, 147), ylim = c(29.6, 47), pref = T,
	 coast = T, add = F, okinawa = T, ar = 4/5, eps = 0.25, ...)
{
  option <- rep(T, 85)			# there are 85 blocks
  if(pref == F)
    option[38:78] <- F
  if(coast == F)
    option[c(1:37, 79:85)] <- F
  if(okinawa == F)
    option[79:85] <- F
  ## range of x and y
  rx <- NULL
  ry <- NULL
  if(!missing(region)) {
    if(!is.null(names(region)) && all(names(region) == c("x", "y"))) {
      rx <- c(region$x - eps, region$x + eps)
      ry <- c(region$y - eps, region$y + eps)
    }
    else {
      for(i in 1:length(region)) {
	rx <- c(rx, region[[i]]$x)
	ry <- c(ry, region[[i]]$y)
      }
      rx <- range(rx)
      ry <- range(ry)
      rx <- c(rx[1] - eps, rx[2] + eps)
      ry <- c(ry[1] - eps, ry[2] + eps)
    }
  }
  else {
    if(add) {
      rx <- par("usr")[1:2]
      ry <- par("usr")[3:4]
    }
    else {
      rx <- range(xlim)
      ry <- range(ylim)
    }
  }
  oldpar <- par(err = -1)
  on.exit(par(oldpar))
  if(!add) {
    frame()
    pxy <- par("pin")
    dx <- ar * (rx[2] - rx[1])
    dy <- ry[2] - ry[1]
    coord <- min(pxy[1] / dx, pxy[2] / dy)
    xextra <- ((pxy[1] / coord - dx) * 0.5) / ar
    yextra <- (pxy[2] / coord - dy) * 0.5
    par(usr = c(rx[1] - xextra, rx[2] + xextra,
	        ry[1] - yextra, ry[2] + yextra))
  }
  bx <- jpn.b$x				# x limits of blocks
  by <- jpn.b$y				# y limits of blocks
  selection <- ((!(bx[2, ] < rx[1] | rx[2] < bx[1, ])) &
		(!(by[2, ] < ry[1] | ry[2] < by[1, ])))
  dd <- if(okinawa)
    diff(c(F, selection & option, F))
  else
    diff(c(F, selection & option))	# interruptions
  start <- jpn.b$start[(dd == 1)[1:85]]	# start points
  end <- jpn.b$end[rep((dd == -1)[-1], length = 85)] # end points
  id <- NULL
  for(i in 1:length(start)) {
    id <- start[i]:end[i]
    lines(jpn.x[id], jpn.y[id], ...)
  }
}

"jpn.x" <-
c(141.9367, 141.9033, 141.8825, 141.868, 141.828, 141.7772, 141.7308,
  141.6904, 141.6744, 141.6581, 141.6342, 141.6312, 141.6344, 141.6165,
  141.5763, 141.589, 141.6346, 141.6559, 141.6883, 141.7466, 141.7906,
  141.8102, 141.7984, 141.7728, 141.742, 141.7053, 141.6745, 141.6683,
  141.6703, 141.657, 141.6118, 141.5567, 141.485, 141.4419, 141.3779,
  141.3635, 141.3744, 141.3756, 141.4034, 141.3893, 141.41, 141.422,
  141.4196, 141.4268, 141.4106, 141.3909, 141.3504, 141.3215, 141.2787,
  141.1959, 141.1504, 141.0989, 141.0806, 141.0968, 141.0556, 141.0078,
  140.9473, 140.8741, 140.7946, 140.8057, 140.7668, 140.7308, 140.7016,
  140.6615, 140.6309, 140.6034, 140.5865, 140.5372, 140.489, 140.389,
  140.4008, 140.3617, 140.4196, 140.4523, 140.5004, 140.5374, 140.5423,
  140.4886, 140.3947, 140.3182, 140.2815, 140.2525, 140.2356, 140.2081,
  140.1607, 140.1508, 140.1076, 140.0623, 140.02, 139.9468, 139.9022,
  139.8506, 139.8284, 139.8453, 139.8643, 139.851, 139.801, 139.7815,
  139.789, 139.832, 139.8797, 139.9078, 139.9447, 139.9897, 140.0533,
  140.0877, 140.1235, 140.1339, 140.126, 140.1055, 140.0647, 140.0423,
  140.0134, 139.9852, 139.9639, 139.9843, 140.0099, 140.0354, 140.0703,
  140.173, 140.1939, 140.2169, 140.2418, 140.2709, 140.3132, 140.3878,
  140.4378, 140.4442, 140.4432, 140.4803, 140.5595, 140.6231, 140.642,
  140.7014, 140.7403, 140.7232, 140.7138, 140.7261, 140.7261, 140.7899,
  140.9257, 141.0104, 141.1052, 141.2101, 141.2615, 141.2057, 141.1702,
  141.0724, 140.9922, 140.9193, 140.9035, 140.8745, 140.8515, 140.8235,
  140.7731, 140.7205, 140.6613, 140.6122, 140.5687, 140.5346, 140.495,
  140.458, 140.409, 140.3586, 140.3279, 140.317, 140.3357, 140.3511,
  140.3642, 140.3821, 140.4043, 140.4474, 140.4823, 140.5395, 140.5927,
  140.6115, 140.668, 140.739, 140.7825, 140.8006, 140.825, 140.8776,
  140.9009, 140.915, 140.9362, 140.9626, 140.9792, 141.0475, 141.0857,
  141.172, 141.2564, 141.3001, 141.3633, 141.467, 141.5378, 141.5995,
  141.6467, 141.6944, 141.7565, 141.8357, 141.9112, 141.9645, 142.0232,
  142.079, 142.137, 142.1943, 142.2598, 142.3085, 142.3511, 142.4138,
  142.4808, 142.5265, 142.586, 142.641, 142.6845, 142.766, 142.837,
  142.9148, 142.9583, 143.0155, 143.0727, 143.1165, 143.2035, 143.2344,
  143.2662, 143.2857, 143.3287, 143.3152, 143.3306, 143.3262, 143.3553,
  143.389, 143.3646, 143.3928, 143.4176, 143.3889, 143.3983, 143.3951,
  143.4276, 143.454, 143.48, 143.4945, 143.5393, 143.5662, 143.6184,
  143.6446, 143.7077, 143.7582, 143.813, 143.853, 143.9098, 143.9488,
  143.9977, 144.0557, 144.1068, 144.1745, 144.2248, 144.2654, 144.3454,
  144.4063, 144.4716, 144.515, 144.5802, 144.6511, 144.7017, 144.743,
  144.8098, 144.8158, 144.786, 144.755, 144.7945, 144.8427, 144.8816,
  144.8906, 144.8628, 144.9178, 144.8998, 144.9296, 144.9373, 144.9524,
  145.021, 145.0554, 145.0776, 145.1066, 145.1455, 145.1621, 145.1987,
  145.2243, 145.1792, 145.1448, 145.167, 145.2334, 145.2806, 145.3283,
  145.3957, 145.4346, 145.4757, 145.5467, 145.5498, 145.5686, 145.5873,
  145.6036, 145.6544, 145.7182, 145.7727, 145.8293, 145.7949, 145.7635,
  145.7255, 145.668, 145.6274, 145.5752, 145.5475, 145.4981, 145.4538,
  145.408, 145.3946, 145.3602, 145.3413, 145.307, 145.2977, 145.2814,
  145.2578, 145.2372, 145.2007, 145.249, 145.288, 145.3131, 145.3029,
  145.3266, 145.3489, 145.3626, 145.386, 145.3333, 145.2738, 145.2015,
  145.1468, 145.137, 145.109, 145.0871, 145.0996, 145.1278, 145.1637,
  145.2004, 145.2175, 145.212, 145.2494, 145.3004, 145.3441, 145.332,
  145.3153, 145.309, 145.2763, 145.249, 145.2225, 145.1729, 145.1292,
  145.0601, 144.9765, 144.9245, 144.8546, 144.778, 144.7098, 144.6309,
  144.5191, 144.455, 144.3795, 144.3514, 144.3214, 144.3076, 144.2446,
  144.2231, 144.2071, 144.1786, 144.1818, 144.1735, 144.1243, 144.0991,
  144.1308, 144.158, 144.175, 144.1398, 144.062, 143.9986, 143.9368,
  143.8887, 143.8075, 143.7973, 143.8382, 143.8817, 143.8926, 143.8437,
  143.772, 143.7254, 143.7032, 143.6846, 143.7338, 143.763, 143.7289,
  143.6854, 143.603, 143.5343, 143.4474, 143.415, 143.3511, 143.277,
  143.1824, 143.1557, 143.0913, 143.0269, 142.9613, 142.8935, 142.8594,
  142.797, 142.762, 142.7027, 142.6578, 142.6225, 142.5669, 142.54,
  142.5095, 142.4511, 142.4298, 142.3612, 142.3322, 142.274, 142.2569,
  142.1601, 142.126, 142.087, 142.0299, 142.0037, 141.9542, 141.9058, NA,
  141.4596, 141.4839, 141.4487, 141.4012, 141.413, 141.3823, 141.3775,
  141.3954, 141.3844, 141.3795, 141.4067, 141.4095, 141.4473, 141.5094,
  141.5533, 141.6368, 141.7097, 141.7368, 141.7899, 141.7729, 141.8125,
  141.7756, 141.806, 141.8712, 141.8558, 141.8739, 141.8874, 141.9161,
  141.9174, 141.8914, 141.8805, 141.9366, 141.8848, 141.8815, 141.8782,
  141.8583, 141.8901, 141.8505, 141.8214, 141.8167, 141.8013, 141.8316,
  141.7903, 141.7505, 141.7624, 141.6938, 141.6312, 141.6158, 141.5548,
  141.506, 141.4527, 141.4738, 141.4524, 141.4766, 141.446, 141.4413,
  141.4565, 141.4396, 141.4165, 141.357, 141.392, 141.3552, 141.375,
  141.3946, 141.4372, 141.402, 141.4415, 141.4307, 141.42, 141.3652,
  141.3438, 141.338, 141.3108, 141.2105, 141.157, 141.0945, 141.111,
  141.0698, 140.9679, 140.934, 140.9172, 140.8668, 140.8711, 140.7827,
  140.8282, 140.8553, 140.8475, 140.858, 140.9263, 140.885, 140.8742,
  140.8908, 140.8815, 140.9042, 140.8903, 140.8963, 140.9037, 140.9218,
  140.9033, 140.9153, NA, 140.9153, 140.9012, 140.8614, 140.828, 140.8156,
  140.8459, 140.8699, 140.8484, 140.7967, 140.7722, 140.7035, 140.6682, NA,
  140.6682, 140.6329, 140.6145, 140.5915, 140.5837, 140.5469, 140.5254,
  140.5175, 140.4793, 140.444, 140.4727, 140.4617, 140.4829, 140.5512,
  140.5982, 140.645, 140.6966, 140.7527, 140.8013, 140.8681, 140.8041,
  140.7737, 140.7214, 140.6653, 140.6295, 140.5835, 140.5477, 140.4852,
  140.45, 140.4151, 140.3853, 140.3644, 140.3462, 140.3224, 140.3091,
  140.291, 140.3052, 140.3175, 140.3419, 140.3295, 140.3266, 140.2923,
  140.2572, 140.2013, 140.1493, 140.124, NA, 140.124, 140.0929, 140.054,
  140.032, 139.9911, 139.9496, 139.8848, 139.903, 139.8887, 139.8389,
  139.7872, 139.7634, 139.7235, 139.7191, 139.7483, 139.8022, 139.7848,
  139.7623, 139.7586, 139.7532, 139.7907, 139.804, 139.785, 139.7781,
  139.8368, 139.8644, 139.8375, 139.8575, 139.9203, 139.9371, 140.0237,
  139.998, 139.9924, 139.9328, 139.9094, 139.8767, 139.8362, 139.799,
  139.7877, 139.7553, 139.7284, 139.7036, 139.727, 139.7032, 139.689,
  139.6408, 139.5938, 139.5843, 139.5681, 139.5804, 139.6045, 139.5798,
  139.5591, 139.5857, 139.6034, 139.682, 139.616, 139.5748, 139.4745,
  139.4853, 139.4658, 139.335, 139.2436, 139.163, 139.1172, 139.0424,
  139.0665, 139.0299, 138.9536, 138.9762, 138.9653, 139.0049, 138.994,
  138.9649, 138.9509, 138.8975, 138.876, 138.8027, 138.7615, 138.6946,
  138.6933, 138.6917, 138.6863, 138.6816, 138.6635, 138.6896, 138.6823,
  138.745, 138.6919, 138.6325, 138.5579, 138.4954, 138.4357, 138.3823,
  138.3471, 138.2663, 138.2175, NA, 138.2175, 138.2173, 138.1852, 138.1682,
  138.1026, 138.075, 138.1555, 137.9715, 137.8892, 137.7492, 137.6245,
  137.4935, 137.4694, 137.2805, 137.1769, 137.0383, 136.994, 136.9728,
  137.0445, 137.1313, 137.1772, 137.1454, 137.0526, 136.9506, NA, 136.9506,
  136.8944, 136.876, 136.917, 136.8924, 136.8255, 136.8197, 136.8124,
  136.8217, 136.8617, 136.8573, 136.9017, 136.7994, 136.717, 136.6088,
  136.5812, 136.5533, 136.4876, 136.4966, 136.4979, 136.5768, NA, 136.5768,
  136.61, 136.6921, 136.7683, 136.814, 136.9143, 136.879, 136.7967,
  136.8284, 136.7308, 136.67, 136.5514, 136.5678, 136.5056, 136.4143,
  136.3913, 136.277, 136.1825, 136.1321, 136.1075, 136.1789, 136.0949,
  136.0506, 135.985, 135.9514, 135.9132, 135.8748, 135.8365, 135.7846,
  135.7249, 135.6594, 135.4965, 135.4585, 135.346, 135.2988, 135.2519,
  135.2477, 135.1977, 135.131, 135.0397, 134.9838, 135.0523, 135.0814,
  135.0405, 135.0788, 135.073, 135.0321, 135.0172, 135.0903, 135.1755,
  135.2914, 135.3282, 135.4167, NA, 135.4167, 135.4597, 135.466, 135.3612,
  135.2365, 135.2135, 135.1312, 135.0473, 134.956, 134.8816, NA, 134.8816,
  134.7312, 134.6278, 134.5971, 134.5044, 134.4875, 134.39, 134.2742, NA,
  134.2742, 134.1952, 134.1326, 134.1491, 134.1109, 134.0515, 133.9539,
  133.9282, 133.9329, 133.8522, 133.7517, 133.6436, 133.622, 133.5718,
  133.4576, NA, 133.4576, 133.433, 133.3933, 133.2805, 133.2136, 133.1011,
  133.1083, 132.9547, 132.8618, 132.7687, 132.729, 132.6088, 132.5055,
  132.5164, 132.4099, 132.3275, 132.239, 132.2173, 132.1682, 132.1862, NA,
  132.1862, 132.0704, 131.9305, NA, 131.9305, 131.9046, 131.7755, 131.713,
  131.6414, 131.5394, 131.4423, 131.4056, 131.3704, 131.223, 131.2394,
  131.1026, 131.042, 130.9884, 130.935, 130.9492, 130.9875, 131.035,
  130.979, 131.031, 131.1528, 131.241, 131.3292, 131.4313, 131.529, 131.581,
  131.6588, 131.7489, 131.8662, 131.9425, 132.0187, 132.0693, NA, 132.0693,
  132.2143, 132.3438, 132.4964, 132.678, 132.8198, 132.8718, 132.9863,
  133.0808, 133.212, 133.3308, 133.451, 133.553, 133.4449, 133.3033,
  133.265, 133.3227, 133.4139, 133.446, 133.396, 133.4371, 133.507,
  133.5618, 133.6685, 133.775, 133.9196, 134.0339, 134.1967, NA, 134.1967,
  134.3078, 134.3749, 134.4938, 134.5777, 134.6463, 134.8136, NA, 134.8136,
  134.9232, 135.0237, 135.1563, 135.1747, 135.2753, 135.3651, 135.432,
  135.4029, 135.3723, 135.3386, 135.3567, 135.4648, NA, 135.4648, 135.5576,
  135.5925, 135.6685, 135.7644, 135.7601, 135.83, 135.8588, 135.9105,
  135.9519, 135.9932, 136.042, 136.1152, 136.1453, 136.1614, 136.1586, NA,
  136.1586, 136.0843, 136.0648, 136.0392, 136.1245, 136.1598, 136.2437,
  136.2834, 136.3687, 136.4541, 136.5456, 136.5993, 136.6542, 136.67,
  136.67, 136.682, 136.82, 136.82, 136.821, 136.8, 136.78, 136.841,
  136.8415, 136.8598, 136.8782, 136.9318, 137.0047, 137.1037, 137.1815,
  137.2668, 137.3523, 137.43, 137.5229, 137.5058, 137.4464, 137.3809,
  137.3563, 137.3514, 137.295, 137.2477, 137.2186, 137.1639, 137.0998,
  137.1198, 137.0482, 137.0113, 137.069, 137.1223, 137.1678, 137.1552,
  137.1169, 137.12, 137.22, 137.2214, 137.3432, 137.4041, 137.47, 137.5326,
  137.615, 137.717, 137.8069, 137.8832, 137.9853, 138.028, 138.1179,
  138.1119, 138.2294, NA, 138.2294, 138.3405, 138.4245, 138.5008, NA,
  138.5008, 138.536, 138.6353, 138.7071, 138.7546, 138.825, 138.8755,
  138.9292, 139.01, 139.094, NA, 139.094, 139.4113, 139.4113, 139.4113,
  139.4113, 139.4741, 139.5034, 139.5129, 139.568, 139.6322, 139.6936, NA,
  139.6936, 139.7578, 139.842, 139.8956, 139.9525, 139.9513, 139.9532,
  140.0341, 140.0693, 140.0954, 140.1124, 140.0838, 140.1387, 140.136,
  140.0922, 139.9875, 139.96, 139.867, 139.8094, 139.7748, 139.8387,
  139.886, 139.93, 139.9698, 140.0462, 140.0783, 140.0968, 140.0714,
  140.0351, 140.0308, 140.06, 140.0176, 139.9826, 140.0514, 140.1399,
  140.2497, 140.3121, 140.3413, 140.3734, 140.3872, 140.3538, 140.4118,
  140.4243, 140.42, 140.3288, 140.3943, 140.437, 140.4342, 140.4603,
  140.5012, 140.568, 140.6275, 140.6822, 140.7201, 140.72, 140.76, 140.75,
  140.78, 140.8256, 140.917, 140.9552, 140.8853, 140.9418, 140.9418,
  141.0117, 141.1195, 141.1669, 141.2113, 141.2374, 141.2375, 141.25,
  141.1727, 141.1727, 141.1435, 141.11, 141.008, 140.9546, 140.889,
  140.8083, 140.7964, 140.873, 140.9175, 140.8828, 140.9925, 141.0669,
  141.1477, 141.2236, 141.2995, 141.365, 141.4002, 141.4474, 141.4854, NA,
  138.3148, 138.3195, 138.3455, 138.4112, 138.4465, 138.5045, 138.5413,
  138.5931, 138.5868, 138.5957, 138.5695, 138.5617, 138.6256, 138.6669,
  138.7125, 138.6482, 138.5963, 138.5519, 138.4618, 138.4374, 138.3643,
  138.3064, 138.334, 138.3783, 138.4227, 138.4184, 138.4016, 138.3649,
  138.3388, 138.3148, NA, 134.7092, 134.7792, 134.8386, 134.8784, 134.8482,
  134.8285, 134.8669, 134.9127, 134.9586, 135.0075, 134.9786, 134.965,
  134.8841, 134.814, 134.7878, 134.7434, 134.6581, 134.5984, 134.6502,
  134.6636, 134.7167, NA, 132.3354, 132.3655, 132.3395, 132.2739, 132.3513,
  132.2797, 132.3023, 132.4074, 132.4683, 132.4833, 132.4694, 132.448,
  132.5483, 132.5971, 132.7264, 132.7812, 132.7886, 132.8284, 132.8469,
  132.838, 132.8, 132.8018, 132.8643, 132.9208, 132.956, 132.979, 133.037,
  133.0524, 133.1045, 133.2006, 133.248, 133.3088, 133.308, 133.306,
  133.3912, 133.4506, 133.3991, 133.524, 133.6351, 133.7141, 133.8236,
  133.8553, 133.9328, 133.9645, 134.0023, 134.0588, 134.0925, 134.0485,
  134.1203, 134.1509, 134.1785, 134.2015, 134.2153, NA, 134.2153, 134.3173,
  134.348, 134.3969, 134.505, 134.6057, 134.7032, 134.6561, 134.6075, NA,
  134.6075, 134.6106, 134.55, 134.5883, 134.5364, 134.5024, 134.528, 134.55,
  134.4404, 134.3692, 134.3465, 134.2374, NA, 134.2574, 134.1647, 134.0962,
  134.0079, 134.049, 134.0096, 133.9638, 133.8982, 133.81, 133.737,
  133.7231, 133.6817, 133.6207, 133.564, 133.6035, 133.5273, 133.486,
  133.4175, 133.3018, 133.1815, 133.1523, 133.0794, 133.049, 133.0172,
  132.9687, 132.9353, 132.8974, 132.847, 132.7996, 132.7126, NA, 132.7126,
  132.6681, 132.6708, 132.5518, 132.4572, 132.3748, 132.2575, 132.204,
  132.1446, NA, 132.1446, 132.0242, 132.0103, 132.0895, 132.1856, NA,
  132.1856, 132.2785, 132.347, 132.321, 132.3162, 132.3022, 132.36,
  132.3354, NA, 131.0244, 131.0027, 131.0144, 130.9776, 130.9819, 131.0255,
  131.0183, 131.0508, 131.1232, 131.164, 131.1979, 131.2595, 131.3033,
  131.3592, 131.4017, 131.4406, 131.4646, 131.517, 131.5644, 131.6194,
  131.6773, 131.6871, 131.7406, 131.748, 131.7122, 131.7184, 131.7054,
  131.6768, 131.6681, 131.6372, 131.595, 131.5871, 131.5592, 131.5135,
  131.5019, 131.4889, 131.4969, 131.5093, 131.5721, 131.6338, 131.6969,
  131.7538, 131.8206, 131.8557, 131.9087, 131.899, 131.8504, 131.8356,
  131.8452, 131.8895, 131.9492, 131.9969, 131.9877, 131.9421, 131.9116,
  131.9322, 131.97, NA, 131.97, 132.0217, 132.0725, 132.0684, 132.0326,
  132.0094, 132.0194, 131.9834, NA, 131.9834, 131.9349, 131.933, 131.9991,
  132.0254, 131.9876, 131.9246, 131.8633, 131.8923, 131.8633, 131.8476,
  131.8317, 131.8223, 131.8148, 131.8047, 131.7877, 131.7895, 131.7338,
  131.7425, 131.6928, 131.71, 131.7192, 131.709, 131.6767, 131.6584,
  131.6977, 131.6608, 131.626, 131.6318, 131.6071, 131.5789, 131.5615,
  131.5718, 131.5433, 131.5366, 131.5053, 131.4619, 131.4521, 131.4603,
  131.4655, 131.4992, 131.4874, 131.4856, 131.491, 131.502, 131.4612,
  131.4286, 131.3957, 131.4125, 131.412, 131.394, 131.3802, 131.371,
  131.3457, 131.3097, 131.2742, 131.2462, 131.2312, 131.1836, 131.1565,
  131.1346, 131.0856, 131.0688, 131.043, 131.0216, 131.0055, 131.0353,
  131.0742, 131.108, 131.1207, 131.1062, 131.139, 131.1113, 131.0807,
  131.0469, 131.0156, 131.0004, 130.9755, 131.0004, 130.9444, 130.8979,
  130.8331, 130.8089, 130.7689, 130.7373, 130.7022, 130.672, 130.6774,
  130.6579, 130.6986, 130.7369, 130.747, 130.7769, 130.7745, 130.7736,
  130.7971, 130.7828, 130.7747, 130.7492, 130.7202, 130.691, 130.702,
  130.6922, 130.6586, 130.6248, 130.6193, 130.6054, 130.6414, 130.679,
  130.7139, 130.7146, 130.7396, 130.7702, 130.7542, 130.7906, 130.8043,
  130.8428, 130.8237, 130.7862, 130.7714, 130.7114, 130.6596, 130.6448,
  130.6275, 130.5933, 130.5555, 130.5329, 130.515, 130.5251, 130.5347,
  130.5513, 130.5611, 130.5991, 130.6222, 130.664, 130.6899, 130.6718,
  130.6434, 130.6228, 130.5987, 130.5492, 130.5094, 130.4741, 130.4938,
  130.4859, 130.4437, 130.3976, 130.3408, 130.311, 130.2831, 130.2734,
  130.229, 130.177, 130.1471, 130.13, 130.1558, 130.192, 130.176, 130.1247,
  130.0941, 130.1046, 130.1529, 130.1927, 130.2531, 130.2887, 130.3046,
  130.3104, 130.3124, 130.318, 130.3052, 130.2791, 130.2326, 130.2026,
  130.1608, 130.1606, 130.1867, 130.2048, 130.2142, 130.1917, 130.1798,
  130.1563, 130.1809, 130.1888, 130.1525, 130.0834, 130.0912, 130.1172,
  130.096, 130.0628, 130.017, 130.0096, 129.9814, 129.9797, 129.9913,
  129.9989, 129.9714, 129.9758, 129.9917, 130.0365, 130.0038, 130.0175,
  130.0758, 130.1148, 130.1477, 130.1951, 130.217, 130.2083, 130.2461,
  130.2727, 130.3195, 130.355, 130.392, 130.4044, 130.454, 130.4438,
  130.406, 130.4067, 130.4205, 130.4546, 130.5089, 130.5503, 130.5962,
  130.5933, 130.5841, 130.5682, 130.5195, 130.4678, 130.4405, 130.396,
  130.4134, 130.4014, 130.341, 130.2992, 130.263, 130.2891, 130.2204,
  130.1795, 130.1338, 130.1517, 130.1813, 130.2128, 130.205, 130.1792,
  130.1546, 130.1211, 130.1155, 130.1629, 130.202, 130.2477, 130.2966,
  130.3427, 130.3544, 130.3758, 130.342, 130.308, 130.2971, 130.3011,
  130.2917, 130.2595, 130.2279, 130.213, 130.1696, 130.1186, 130.1058,
  130.1195, 130.1325, 130.1747, 130.184, 130.1978, 130.1669, 130.1291,
  130.0866, 130.0367, 129.9886, 129.945, 129.9023, 129.9048, 129.8717,
  129.8323, 129.7909, 129.7542, 129.7511, 129.7627, 129.7924, 129.8054,
  129.7596, 129.7544, 129.761, 129.7949, 129.7544, 129.7214, 129.6768,
  129.6419, 129.6388, 129.6163, 129.6333, 129.6561, 129.6706, 129.6706,
  129.6632, 129.6905, 129.6606, 129.6346, 129.5988, 129.5603, 129.5405,
  129.5753, 129.538, 129.523, 129.5026, 129.4658, 129.4563, 129.4279,
  129.39, 129.3387, 129.398, 129.4132, 129.429, 129.4405, 129.4259, 129.476,
  129.5098, 129.5279, 129.5557, 129.5642, 129.6058, 129.655, 129.6644,
  129.7286, 129.7537, 129.7814, 129.797, 129.8129, 129.8664, 129.8926,
  129.9245, 129.933, 129.952, 129.9659, 129.9521, 129.984, 130.002,
  130.0428, 130.0894, 130.0934, 130.0755, 130.0852, 130.0946, 130.1328,
  130.1377, 130.1364, 130.1896, 130.2243, 130.2815, 130.3296, 130.3739,
  130.4225, 130.4605, 130.4415, 130.447, 130.4636, 130.4878, 130.5764,
  130.6316, 130.7016, 130.7517, 130.7944, 130.8412, 130.8831, 130.935,
  130.9851, 131.0191, NA, 129.4596, 129.4746, 129.4796, 129.5095, 129.5037,
  129.4813, 129.456, 129.4004, 129.388, 129.367, 129.4062, 129.4133,
  129.4053, 129.37, 129.3607, 129.3043, 129.2977, 129.238, 129.2728, 129.29,
  129.2541, 129.2467, 129.2847, 129.2977, 129.3399, 129.2995, 129.3183,
  129.3462, 129.3352, 129.3453, 129.3836, 129.4288, 129.4447, 129.4494, NA,
  129.1463, 129.1354, 129.1356, 129.1022, 129.0788, 129.0897, 129.0533,
  129.0942, 129.0884, 129.0665, 129.0568, 129.1508, 129.1443, 129.1025,
  129.1143, 129.1002, 129.0835, 129.06, 129.0224, 129.005, 128.9855,
  128.9258, 128.95, 128.9004, 128.8904, 128.8609, 128.8325, 128.8407,
  128.8352, 128.8034, 128.7781, 128.7562, 128.7457, 128.7219, 128.694,
  128.6638, 128.6253, 128.633, 128.6681, 128.6387, 128.6307, 128.6105,
  128.6175, 128.6902, 128.7309, 128.7807, 128.7906, 128.7978, 128.7702,
  128.7774, 128.7854, 128.843, 128.8859, 128.8618, 128.877, 128.8253,
  128.8318, 128.815, 128.8647, 128.8886, 128.8416, 128.8848, 128.8891,
  128.9246, 128.924, 128.94, 128.9354, 128.9542, 128.998, 129.0279,
  129.0345, 129.0389, 129.0687, 129.0803, 129.1074, 129.1157, 129.064,
  129.0843, 129.0808, 129.1127, NA, 140.0681, 140.1472, 140.2878, 140.3639,
  140.4283, 140.4986, 140.5865, 140.6919, 140.8208, 140.9086, 140.9584,
  141.0111, 140.9877, 140.9965, 141.1049, 141.1956, 141.3626, 141.5031,
  141.588, NA, 140.9643, 140.932, 140.8706, 140.8706, 140.856, 140.856,
  140.856, 140.856, 140.9028, 140.8442, 140.812, 140.7622, 140.6919,
  140.6685, 140.689, 140.7388, 140.7388, 140.7563, 140.7563, 140.8354,
  140.9145, 141.0023, 141.0785, 141.1634, 141.219, 141.307, 141.3362,
  141.386, 141.4182, 141.4914, 141.5441, NA, 140.7183, 140.5923, 140.4752,
  140.3844, 140.361, 140.2526, 140.1267, 140.0769, 139.9773, NA, 140.6392,
  140.5836, 140.5836, 140.5836, 140.5484, 140.5806, 140.5806, 140.5308,
  140.4606, 140.4166, 140.2878, 140.32, 140.4283, 140.5367, 140.6363,
  140.6363, 140.8266, 140.856, NA, 140.2848, 140.2438, 140.2438, 140.0505,
  139.9041, 139.6493, 139.6757, 139.7489, 139.9451, 139.8309, 139.7401,
  139.7401, 139.6083, NA, 139.7723, 139.6757, 139.6083, 139.579, 139.456,
  139.2598, 139.2335, 139.2335, 139.2335, 139.2686, 139.2686, 139.3799,
  139.4648, 139.5205, 139.6435, 139.7548, 139.951, 140.0945, 140.1794,
  140.2292, 140.2292, 140.3405, 140.4283, 140.4664, 140.5543, 140.5836,
  140.6831, 140.7446, NA, 140.2278, 140.2028, 140.205, 140.2028, 140.2278,
  140.2278, 140.2187, 140.2187, 140.2096, 140.2005, 140.2028, 140.2119,
  140.2119, 140.2119, 140.2119, 140.1868, 140.1595, 140.1276, 140.0684,
  140.0342, 139.9932, 139.9226, 139.8816, 139.8634, 139.827, 139.7837,
  139.7495, 139.7335, 139.7199, 139.7085, 139.6857, 139.6834, 139.6766,
  139.6607, 139.631, 139.606, 139.606, 139.59, 139.5536, 139.5149, 139.4875,
  139.4534, 139.4397, 139.4124, 139.3782, 139.3463, 139.3418, 139.36,
  139.3941, 139.4124, 139.4397, 139.4033, 139.3668, 139.335, 139.335,
  139.335, 139.3372, 139.3418, 139.369, 139.3463, 139.3531, 139.3577, NA,
  140.8565, 140.7905, 140.7449, 140.6857, 140.6196, 140.5718, 140.533,
  140.492, 140.451, 140.4169, 140.3554, 140.3121, 140.2711, 140.2187,
  140.1754, 140.1322, 140.0752, 139.9978, 139.95, 139.9203, 139.8862,
  139.8565, 139.836, 139.7928, 139.7586, 139.7085, 139.6743, 139.615,
  139.615, 139.6584, 139.6857, 139.7267, 139.7495, 139.7768, 139.7768,
  139.7928, 139.811, 139.8315, 139.8315, 139.8315, 139.8383, 139.8383,
  139.8657, NA, 139.6242, 139.5582, 139.4967, 139.4374, 139.3782, 139.328,
  139.2825, 139.2142, 139.1481, 139.1277, 139.0639, 139.0525, 139.0434,
  139.0297, 138.9933, 138.9523, 138.8976, 138.8429, 138.7882, 138.7564,
  138.7154, 138.6903, 138.6903, 138.6698, 138.7199, 138.8088, 138.8816,
  138.959, 138.9955, 139.048, 139.089, 139.1413, 139.1891, 139.2415,
  139.2848, 139.3509, 139.3782, 139.417, 139.417, 139.4192, 139.3941,
  139.369, 139.3372, 139.3531, 139.4055, 139.4534, 139.508, 139.5422,
  139.5969, 139.6424, 139.6698, 139.7017, 139.7176, NA, 138.9318, 138.959,
  138.9955, 139.0297, 139.0548, 139.1026, 139.139, 139.1891, 139.2484,
  139.2917, 139.344, 139.3873, 139.4602, 139.508, 139.5582, 139.6174,
  139.6607, 139.7108, 139.7495, 139.786, 139.8133, NA, 138.6607, 138.6425,
  138.5855, 138.5354, 138.4898, 138.4511, 138.417, 138.3623, 138.3486,
  138.3122, 138.2644, 138.2188, 138.2097, 138.196, 138.171, 138.1573,
  138.1368, 138.1687, 138.1846, 138.1755, 138.1755, 138.1937, 138.1937,
  138.2028, 138.2028, 138.2097, 138.2142, 138.2279, 138.2438, 138.2735,
  138.3031, 138.3213, 138.3372, 138.3668, 138.3965, 138.4488, 138.4762,
  138.5035, 138.4807, 138.4488, 138.4648, 138.483, 138.4648, 138.508,
  138.5331, 138.5605, 138.5969, 138.6425, 138.6812, 138.704, 138.7655,
  138.7905, 138.8247, 138.8589, 138.8908, 138.9113, 138.9409, 138.959,
  138.9705, 138.9523, 138.9363, 138.9204, 138.9431, 138.9454, 138.9841,
  139.0001, 139.0297, NA, 139.0867, 139.089, 139.089, 139.0775, 139.048,
  139.0343, 138.9796, 138.9409, 138.9113, 138.8839, 138.8839, NA, 138.1414,
  138.1117, 138.1004, 138.1004, 138.098, 138.0935, 138.073, 138.0502,
  138.0229, 137.9637, 137.9136, 137.8885, 137.852, 137.827, 137.7837,
  137.761, 137.761, 137.7541, 137.7108, 137.6767, 137.6516, 137.6152,
  137.5901, 137.5719, 137.524, 137.4876, 137.4443, 137.4216, 137.3965,
  137.3965, NA, 139.2552, 139.2301, 139.1891, 139.139, 139.098, 139.073,
  139.0548, 139.0206, 138.9864, 138.9773, 138.9773, 138.9773, 138.9363,
  138.8976, 138.8816, 138.8475, 138.8065, 138.7495, 138.7108, 138.6766,
  138.6356, 138.5764, 138.5195, 138.499, 138.467, 138.4306, 138.3828,
  138.3805, 138.4056, 138.4238, 138.4602, 138.4898, 138.5286, 138.5605,
  138.6037, 138.6356, 138.6766, 138.6447, 138.6106, 138.6106, 138.5832,
  138.5969, 138.6447, 138.6447, 138.6447, 138.6652, 138.6903, 138.7154, NA,
  138.693, 138.6722, 138.6774, 138.6905, 138.7048, 138.6878, 138.6566,
  138.624, 138.624, 138.624, 138.5837, 138.5473, 138.4939, 138.4627,
  138.4275, 138.395, 138.3768, 138.3429, 138.3117, 138.27, 138.2336,
  138.1568, 138.136, 138.1177, 138.1021, 138.0917, 138.0787, 138.0397,
  137.9863, 137.959, 137.9316, 137.9316, 137.9121, 137.9043, 137.89,
  137.847, NA, 137.1637, 137.1298, 137.0817, 137.0491, 137.027, 137.0127,
  137.0023, 136.971, 136.9463, 136.9359, 136.9359, 136.9111, 136.9111,
  136.902, 136.8929, 136.8929, 136.8929, 136.9007, 136.9072, 136.9255,
  136.9554, 136.9801, 137.0179, 137.0335, 137.0556, 137.066, 137.0856,
  137.0999, 137.1168, 137.1493, 137.1806, 137.2183, 137.2483, 137.286,
  137.3485, 137.411, 137.4604, 137.5203, 137.5646, 137.631, 137.6895,
  137.7155, 137.7572, 137.7962, 137.8262, 137.8509, 137.8509, 137.8262,
  137.7923, 137.7715, 137.7325, 137.6908, NA, 137.6349, 137.6349, 137.6557,
  137.6557, 137.6557, 137.64, 137.6218, 137.5984, 137.5984, 137.5984,
  137.5984, 137.5841, 137.5541, 137.5476, 137.4982, 137.4513, 137.4058,
  137.3719, 137.3602, 137.3602, 137.3823, 137.4162, 137.4552, 137.4917,
  137.5047, 137.5047, 137.5047, 137.5047, 137.5203, 137.5502, 137.5789,
  137.5932, 137.5932, 137.5815, 137.5685, 137.5541, 137.545, 137.545,
  137.5919, 137.6505, 137.6856, 137.7286, 137.7689, NA, 136.3801, 136.3918,
  136.3918, 136.3996, 136.436, 136.4686, 136.5129, 136.5675, 136.6261,
  136.669, 136.7367, 136.7719, NA, 136.9177, 136.8877, 136.8487, 136.8643,
  136.8877, 136.9125, 136.9177, 136.8981, 136.8539, 136.8226, 136.8057,
  136.781, 136.7719, 136.7719, 136.8057, 136.8318, 136.8448, 136.859,
  136.8708, 136.8838, 136.8643, 136.837, 136.8057, 136.764, 136.7029,
  136.643, 136.6, 136.5376, 136.4829, 136.4191, 136.3814, 136.371, 136.3475,
  136.3371, 136.2877, 136.2642, 136.25, 136.2369, 136.22, 136.1653,
  136.1185, 136.0742, 136.0208, 135.9636, 135.8998, 135.8412, 135.7722,
  135.711, 135.6564, 135.6186, 135.538, 135.5236, 135.5406, 135.5484, NA,
  134.5523, 134.5523, 134.5523, 134.5523, 134.5523, 134.5523, 134.566,
  134.5796, 134.5933, 134.6108, 134.6147, 134.603, 134.5776, 134.5405,
  134.5074, 134.4859, 134.4859, 134.478, 134.441, 134.4175, 134.359,
  134.359, 134.359, 134.3394, 134.318, 134.3297, 134.3297, NA, 134.9857,
  134.9857, 135.015, 135.0306, 135.0755, 135.1243, 135.1243, 135.1243,
  135.1321, 135.1185, 135.0814, 135.017, 135.017, 135.056, 135.0892,
  135.1419, 135.2005, 135.222, 135.222, 135.2747, 135.3684, 135.4094,
  135.4094, 135.382, 135.382, 135.4035, 135.4308, 135.4504, 135.464,
  135.464, 135.4797, 135.4543, 135.4543, NA, 135.4191, 135.4406, 135.464,
  135.4855, 135.5011, 135.5207, 135.5792, 135.6358, 135.6612, 135.6866,
  135.7022, 135.7198, 135.7198, 135.7198, 135.6983, 135.6593, 135.6241,
  135.6085, 135.6358, 135.6573, 135.6241, 135.6066, 135.5636, 135.4914,
  135.3957, 135.3235, 135.2434, 135.136, 135.0814, 135.0247, NA, 135.5597,
  135.5988, 135.6183, 135.6437, 135.6534, 135.6612, 135.6066, 135.5695,
  135.5285, 135.4797, 135.5128, 135.5578, 135.5578, 135.5304, 135.5109,
  135.5851, 135.6515, 135.7257, 135.7608, 135.7608, 135.7608, 135.792,
  135.835, 135.8643, NA, 135.7842, 135.8116, 135.8506, 135.8506, 135.8799,
  135.8662, 135.8467, 135.8213, 135.8213, 135.8409, 135.8506, 135.9092,
  135.9521, 135.9892, 136.0322, 136.0322, 136.0459, 136.0107, 136.0673,
  136.1318, 136.2079, 136.1689, 136.1396, 136.0615, 136.0029, 136.0302,
  136.0693, 136.0341, 136.0224, 136.0224, 136.0029, 135.9717, 135.8565,
  135.8057, 135.7667, NA, 135.6964, 135.7413, 135.7842, 135.8409, 135.8584,
  135.8838, 135.917, 135.9385, 136.0146, 136.0322, NA, 137.5473, 137.5043,
  137.4672, 137.432, 137.3618, 137.3286, 137.2876, 137.2446, 137.186,
  137.104, 137.0767, 137.024, 136.9947, 136.9381, 136.8854, 136.821,
  136.7663, 136.7116, 136.6667, 136.6355, 136.6003, 136.6101, 136.6296,
  136.6667, 136.6824, 136.7155, NA, 136.04, 136.0634, 136.0908, 136.1279,
  136.1689, 136.2352, 136.2938, 136.3387, 136.3797, 136.4051, 136.4344,
  136.4344, 136.4598, 136.4598, 136.4383, 136.4383, 136.4617, 136.4851,
  136.5203, 136.5652, 136.5945, NA, 134.4931, 134.4619, 134.3942, 134.3239,
  134.2588, 134.1781, 134.1209, 134.0323, 133.9569, 133.897, 133.8423,
  133.7746, 133.7043, 133.6445, 133.6184, 133.5273, 133.5195, 133.483,
  133.4284, 133.3555, 133.2956, 133.2488, 133.2826, 133.3269, 133.3737,
  133.4284, 133.444, 133.444, 133.4622, 133.4414, NA, 133.3659, 133.3946,
  133.3737, 133.3737, 133.4284, 133.444, 133.444, 133.444, 133.457, 133.457,
  133.457, 133.457, NA, 131.8144, 131.8326, 131.804, 131.7884, 131.7962,
  131.8613, 131.8613, 131.8743, 131.9524, 132.0175, 132.0487, 132.0721,
  132.1268, 132.1268, 132.1476, 132.1919, 132.2309, 132.2622, 132.3038,
  132.3429, 132.4288, 132.5563, 132.6917, 132.7672, 132.7672, 132.7854,
  132.8635, 132.9156, 132.9806, 133.0353, 133.1212, 133.1993, 133.2436, NA,
  132.1294, 132.1554, 132.1554, 132.1789, 132.2153, 132.2179, NA, 134.3057,
  134.2302, 134.1703, 134.074, 133.9881, 133.858, 133.6965, 133.634,
  133.5846, NA, 134.1703, 134.139, 134.1, 134.0714, 133.9829, 133.8501,
  133.7252, 133.6549, 133.6236, 133.6549, NA, 132.4704, 132.5069, 132.5355,
  132.5095, 132.4782, 132.585, 132.65, 132.689, 132.788, 132.8192, 132.7776,
  132.7776, 132.8297, 132.9364, 133.004, 133.0405, 133.1004, 133.1577,
  133.2488, 133.3607, 133.5065, 133.569, 133.6132, 133.6861, 133.6861, NA,
  131.1939, 131.1816, 131.1865, 131.1847, 131.1566, 131.1158, 131.0454,
  131.0016, 130.9658, 130.9244, 130.8997, 130.8884, 130.8617, 130.8622,
  130.8024, 130.8416, 130.8794, 130.8883, 130.8664, 130.8384, 130.8803,
  130.9221, 130.953, 130.9807, 130.9937, 131.0247, 131.0134, 130.979,
  130.9966, 131.0594, 131.0999, 131.14, 131.1686, 131.1889, 131.2196,
  131.2576, 131.2589, 131.2706, 131.2956, 131.3493, 131.3791, 131.4446,
  131.4842, 131.5132, 131.5282, 131.5316, 131.5759, 131.625, 131.6698,
  131.7165, 131.7461, 131.7655, 131.8132, 131.861, 131.8704, NA, 131.3258,
  131.2667, 131.232, 131.2175, 131.1856, 131.1442, 131.1124, 131.1064,
  131.0826, 131.0527, 131.0491, 131.0054, 131.0296, 131.0582, 131.0815,
  131.0992, 131.0862, 131.047, 131.0727, 131.1164, 131.1333, 131.0911,
  131.0513, 131.0312, 130.9974, 130.9638, 130.946, 130.9023, 130.8914,
  130.8627, 130.8084, 130.7547, 130.7301, 130.7345, 130.792, 130.8083,
  130.8381, 130.872, 130.8949, 130.9329, 130.9032, 130.9159, 130.9382,
  130.9819, 131.0022, 131.0387, 131.0521, 131.0657, 131.1033, 131.1221,
  131.1756, 131.2313, 131.214, 131.1986, 131.2098, 131.1633, 131.1561, NA,
  130.7166, 130.6538, 130.6068, 130.5561, 130.5068, 130.4509, 130.3852,
  130.3612, 130.3263, 130.3053, 130.3013, 130.2456, 130.1982, 130.1762,
  130.1275, NA, 130.8158, 130.7521, 130.7235, 130.6897, 130.655, 130.6441,
  130.5741, 130.5714, 130.5197, 130.5052, 130.5089, 130.4593, 130.4266, NA,
  130.3406, 130.3274, 130.3623, 130.3819, 130.428, 130.4813, 130.5202,
  130.5587, 130.5439, 130.5106, 130.4575, 130.4273, 130.3795, 130.3417,
  130.2981, 130.2384, 130.2115, 130.1728, 130.1131, 130.0733, NA, 129.6877,
  129.7359, 129.7642, 129.8015, 129.763, 129.7889, 129.8207, 129.8265,
  129.8399, 129.8836, 129.9241, 129.954, 129.946, 129.9084, 129.9471,
  130.0003, 130.0551, 130.1068, 130.1566, 130.1864, NA, 136.3384, 136.3384,
  136.3515, 136.3697, 136.414, 136.4243, 136.44, 136.4595, 136.4725,
  136.4634, 136.4504, 136.4504, 136.4504, 136.44, 136.4335, 136.4295,
  136.47, NA, 131.8333, 131.8385, 131.8316, 131.8535, 131.837, 131.8205,
  131.7958, 131.7736, 131.7557, 131.723, 131.6905, 131.6718, 131.6618,
  131.5964, 131.5744, 131.5579, 131.546, 131.528, 131.5038, 131.4774,
  131.4575, 131.417, 131.3904, 131.3677, 131.3467, 131.3665, 131.3749,
  131.4246, 131.3699, 131.3644, 131.306, 131.2872, 131.305, 131.3533,
  131.355, 131.3131, 131.2964, 131.1928, 131.1538, 131.1747, 131.1622,
  131.1517, 131.2149, 131.2374, 131.2875, 131.2645, 131.2172, 131.2381,
  131.287, 131.3626, 131.465, 131.4794, 131.4253, 131.3843, 131.413, 131.47,
  131.5399, 131.5157, 131.567, 131.6297, 131.6902, 131.71, 131.7635,
  131.7966, 131.8296, NA, 131.4958, 131.4634, 131.4843, 131.5167, 131.4958,
  NA, 131.4473, 131.4175, 131.4275, 131.4578, 131.4457, NA, 131.353,
  131.2828, 131.2718, 131.2961, 131.353, 131.314, NA, 130.871, 130.8523,
  130.7774, 130.8173, 130.871, NA, 130.2375, 130.1869, 130.2224, 130.255,
  130.2792, 130.2891, 130.2208, NA, 130, 132, 132, 130, 130, NA)

"jpn.y" <-
c(45.5225, 45.5042, 45.44466, 45.41704, 45.39127, 45.37997, 45.41236,
  45.45613, 45.46084, 45.43, 45.3845, 45.3385, 45.2944, 45.26027, 45.1839,
  45.14267, 45.0636, 44.99355, 44.9296, 44.7943, 44.6819, 44.5936, 44.5108,
  44.46206, 44.4036, 44.3337, 44.2752, 44.21326, 44.06634, 44.00085,
  43.91474, 43.86528, 43.82445, 43.79773, 43.7715, 43.69886, 43.65436,
  43.6315, 43.59894, 43.5318, 43.49573, 43.4434, 43.39347, 43.35195,
  43.3211, 43.2837, 43.24686, 43.2272, 43.191, 43.1741, 43.1931, 43.20075,
  43.20614, 43.252, 43.26414, 43.2688, 43.2491, 43.2406, 43.2302, 43.2513,
  43.26276, 43.2696, 43.28944, 43.32374, 43.3459, 43.35396, 43.3871,
  43.42407, 43.3726, 43.36825, 43.3254, 43.2712, 43.22043, 43.16204,
  43.10285, 43.0676, 43.04177, 43.005, 42.952, 42.8619, 42.79205, 42.84747,
  42.8806, 42.87365, 42.8388, 42.80985, 42.79815, 42.7571, 42.747, 42.75353,
  42.7291, 42.67114, 42.6289, 42.58076, 42.5264, 42.4759, 42.4062, 42.3688,
  42.34785, 42.29394, 42.25924, 42.23223, 42.212, 42.1669, 42.1219, 42.0818,
  42.02435, 41.9838, 41.91856, 41.87957, 41.83717, 41.77436, 41.7547,
  41.7011, 41.64545, 41.5738, 41.5269, 41.495, 41.46596, 41.4752, 41.44464,
  41.39286, 41.47555, 41.5308, 41.54087, 41.54706, 41.57176, 41.6543,
  41.71273, 41.7431, 41.76296, 41.81365, 41.8494, 41.86193, 41.8505, 41.818,
  41.8001, 41.78337, 41.78337, 41.774, 41.78097, 41.74105, 41.7657,
  41.80426, 41.84167, 41.8412, 41.88916, 41.91417, 41.95274, 41.9798,
  42.0201, 42.0605, 42.0973, 42.1393, 42.1541, 42.1696, 42.1476, 42.13954,
  42.1523, 42.198, 42.2284, 42.26363, 42.2706, 42.2854, 42.32255, 42.36705,
  42.4028, 42.43203, 42.47697, 42.5111, 42.5533, 42.58004, 42.61108,
  42.59425, 42.57485, 42.6106, 42.6277, 42.60686, 42.57906, 42.5381,
  42.51405, 42.49857, 42.45234, 42.4088, 42.3688, 42.3385, 42.29986,
  42.3492, 42.38673, 42.44017, 42.49035, 42.52816, 42.5377, 42.58414,
  42.60833, 42.6202, 42.63447, 42.6298, 42.6322, 42.607, 42.5848, 42.5354,
  42.50124, 42.4567, 42.4715, 42.4547, 42.41853, 42.38546, 42.35604,
  42.32447, 42.286, 42.27256, 42.25506, 42.2239, 42.2111, 42.17024, 42.1494,
  42.1265, 42.1137, 42.0969, 42.08006, 42.0428, 42.0172, 41.9856, 41.9556,
  41.92737, 41.88848, 41.9281, 41.95734, 41.97925, 42.0345, 42.05835,
  42.0824, 42.136, 42.1831, 42.22908, 42.24695, 42.27603, 42.33777,
  42.38813, 42.4124, 42.44, 42.485, 42.51087, 42.5649, 42.60974, 42.66436,
  42.70014, 42.72904, 42.7698, 42.82254, 42.8617, 42.89423, 42.89405,
  42.9259, 42.94915, 42.9644, 42.97, 42.975, 42.96, 42.9312, 42.93343,
  42.9518, 42.93093, 42.9367, 42.92457, 42.93117, 42.94254, 42.9513,
  42.9979, 43.0126, 43.04905, 43.0526, 43.01435, 43.00186, 42.9857, 42.9516,
  42.94285, 42.95747, 42.98117, 42.961, 42.9509, 42.9931, 43.04836,
  43.05194, 43.0433, 43.03254, 43.0813, 43.0908, 43.1009, 43.14315,
  43.12364, 43.1229, 43.14826, 43.16595, 43.18455, 43.17243, 43.15157,
  43.19757, 43.2333, 43.26906, 43.2999, 43.32625, 43.3319, 43.35524,
  43.3874, 43.4125, 43.403, 43.386, 43.38227, 43.37545, 43.3364, 43.3089,
  43.2803, 43.27643, 43.2899, 43.3145, 43.3246, 43.3639, 43.374, 43.40674,
  43.45096, 43.49164, 43.52773, 43.5891, 43.5955, 43.5841, 43.5767, 43.5572,
  43.53707, 43.54927, 43.57527, 43.59465, 43.61013, 43.62763, 43.62075,
  43.6725, 43.70913, 43.73615, 43.7801, 43.82894, 43.88255, 43.9508,
  44.02065, 44.05314, 44.0979, 44.1338, 44.1807, 44.2185, 44.27085, 44.3095,
  44.35266, 44.366, 44.314, 44.26365, 44.21447, 44.17666, 44.1257, 44.0621,
  44.0136, 43.97603, 43.931, 43.9117, 43.89736, 43.89083, 43.9097, 43.9319,
  43.9589, 43.9771, 44.0112, 44.0372, 44.07167, 44.0764, 44.04725, 44.01817,
  43.99245, 44.01443, 44.02183, 44.08195, 44.0683, 44.1008, 44.1093,
  44.11715, 44.13207, 44.15024, 44.16437, 44.16574, 44.14625, 44.1286,
  44.1158, 44.0863, 44.0838, 44.073, 44.08485, 44.13826, 44.1531, 44.16117,
  44.15634, 44.187, 44.1998, 44.224, 44.2442, 44.26977, 44.3037, 44.3431,
  44.378, 44.404, 44.4437, 44.47203, 44.51536, 44.56653, 44.60336, 44.634,
  44.68614, 44.7302, 44.76826, 44.81337, 44.8669, 44.917, 44.9662, 45.0089,
  45.0636, 45.11863, 45.15384, 45.19425, 45.22446, 45.26705, 45.31425,
  45.3449, 45.3864, 45.4032, 45.45404, 45.5005, 45.5241, NA, 41.3243,
  41.31595, 41.2619, 41.18057, 41.0883, 41.03585, 40.9525, 40.87075,
  40.79578, 40.69984, 40.6527, 40.58247, 40.51596, 40.4537, 40.3788,
  40.3218, 40.2968, 40.2182, 40.16535, 40.10504, 40.0915, 40.0222, 39.98033,
  39.9296, 39.8845, 39.8468, 39.7949, 39.7504, 39.6964, 39.6518, 39.5957,
  39.5481, 39.5218, 39.45993, 39.40436, 39.36396, 39.331, 39.3131, 39.27584,
  39.2302, 39.1977, 39.1558, 39.11642, 39.0482, 38.9874, 38.9637, 38.91275,
  38.86135, 38.84447, 38.80455, 38.80707, 38.75574, 38.719, 38.6855,
  38.63303, 38.6126, 38.60736, 38.5659, 38.514, 38.48086, 38.45314,
  38.40904, 38.3991, 38.364, 38.3494, 38.30166, 38.2881, 38.2383, 38.2199,
  38.2387, 38.20825, 38.2858, 38.33924, 38.37366, 38.33845, 38.2938,
  38.25345, 38.20148, 38.2207, 38.1441, 38.11524, 38.0664, 38.01137,
  37.9724, 37.9316, 37.8656, 37.80846, 37.7639, 37.70586, 37.67905, 37.6418,
  37.5889, 37.548, 37.51815, 37.47567, 37.43584, 37.39863, 37.34834,
  37.2917, 37.2372, NA, 37.2372, 37.1507, 37.08247, 37.09394, 37.0541,
  37.0059, 36.92837, 36.87276, 36.8905, 36.8548, 36.79965, 36.7393, NA,
  36.7393, 36.6475, 36.6349, 36.59554, 36.5321, 36.46913, 36.4135, 36.35637,
  36.30965, 36.2493, 36.17335, 36.09837, 36.0596, 36.01413, 35.95707,
  35.88743, 35.83196, 35.7655, 35.72993, 35.707, 35.70326, 35.702, 35.7152,
  35.6942, 35.6786, 35.68068, 35.6514, 35.6279, 35.60435, 35.57686, 35.5541,
  35.51584, 35.49637, 35.45288, 35.42854, 35.3955, 35.33995, 35.32175,
  35.28927, 35.25307, 35.20703, 35.1852, 35.1617, 35.1367, 35.11873, 35.095,
  NA, 35.095, 35.1017, 35.0984, 35.072, 35.038, 35.01195, 34.92087, 34.9539,
  34.9278, 34.89575, 34.8874, 34.91194, 34.9205, 34.9623, 34.95215, 34.9736,
  35.0143, 35.02302, 35.07048, 35.12413, 35.1744, 35.17154, 35.2184, 35.251,
  35.28116, 35.318, 35.34128, 35.3778, 35.41096, 35.43265, 35.4821,
  35.50317, 35.54715, 35.55606, 35.57664, 35.57588, 35.56514, 35.55174,
  35.53087, 35.53975, 35.5358, 35.46338, 35.47, 35.4265, 35.4004, 35.38937,
  35.3625, 35.34512, 35.31557, 35.27013, 35.29607, 35.25084, 35.2086,
  35.2029, 35.17187, 35.17053, 35.1089, 35.09247, 35.12686, 35.1641,
  35.23064, 35.2755, 35.2376, 35.2621, 35.20854, 35.17433, 35.10937,
  35.08415, 35.04103, 34.97345, 34.90476, 34.92265, 34.85396, 34.8041,
  34.73646, 34.69496, 34.65823, 34.60778, 34.58097, 34.6039, 34.6579,
  34.69963, 34.70867, 34.76273, 34.813, 34.8828, 34.95144, 35.02127,
  35.07412, 35.06615, 35.05082, 35.0313, 34.94157, 34.90636, 34.87117,
  34.84535, 34.8117, NA, 34.8117, 34.76768, 34.71887, 34.67743, 34.6401,
  34.5803, 34.52434, 34.578, 34.56214, 34.5598, 34.60256, 34.57822, 34.6306,
  34.6072, 34.57976, 34.5486, 34.50396, 34.549, 34.59054, 34.5954, 34.66154,
  34.7071, 34.7169, 34.71723, NA, 34.71723, 34.73967, 34.7082, 34.6658,
  34.6238, 34.64677, 34.71805, 34.7867, 34.8402, 34.92728, 34.96973,
  35.03953, 34.97697, 34.93594, 34.88175, 34.83453, 34.69924, 34.6493,
  34.60216, 34.55446, 34.4896, NA, 34.4896, 34.4215, 34.39335, 34.405,
  34.41453, 34.3801, 34.31976, 34.2913, 34.2143, 34.1785, 34.19935,
  34.23374, 34.1431, 34.19906, 34.18632, 34.14697, 34.11375, 34.08317,
  34.0532, 33.98607, 33.94583, 33.8833, 33.84495, 33.8202, 33.78136,
  33.72834, 33.66275, 33.59716, 33.56457, 33.46224, 33.45007, 33.4524,
  33.4623, 33.5009, 33.50762, 33.57097, 33.65117, 33.70927, 33.77624,
  33.80754, 33.89918, 33.9103, 33.96015, 34.00883, 34.06184, 34.13312,
  34.1881, 34.2625, 34.2752, 34.27746, 34.33218, 34.38257, 34.45297, NA,
  34.45297, 34.52643, 34.58096, 34.63896, 34.68172, 34.64237, 34.60763,
  34.57026, 34.5764, 34.62397, NA, 34.62397, 34.6913, 34.7268, 34.6743,
  34.6967, 34.66783, 34.6446, 34.62133, NA, 34.62133, 34.65474, 34.5975,
  34.54457, 34.50415, 34.49618, 34.44778, 34.50382, 34.53686, 34.5173,
  34.5203, 34.5227, 34.44824, 34.44344, 34.44167, NA, 34.44167, 34.37453,
  34.33776, 34.30716, 34.3301, 34.3687, 34.2623, 34.29925, 34.2713, 34.2182,
  34.2003, 34.2069, 34.24237, 34.31106, 34.3224, 34.28137, 34.22356,
  34.1365, 34.0274, 33.95193, NA, 33.95193, 33.94124, 33.95777, NA,
  33.95777, 33.9635, 34.04242, 33.99776, 33.99396, 33.988, 34.078, 34.0276,
  33.99872, 34.04617, 33.9555, 34.00245, 34.07363, 34.00068, 33.95917,
  34.096, 34.1616, 34.2618, 34.3157, 34.39233, 34.38835, 34.38326, 34.353,
  34.3841, 34.4325, 34.52172, 34.5549, 34.61532, 34.63493, 34.69063,
  34.72745, 34.81404, NA, 34.81404, 34.923162857143, 34.968325714286,
  35.096858571429, 35.224931428571, 35.303654285714, 35.384857142857,
  35.46666, 35.5035, 35.5656, 35.6004, 35.6064, 35.59346, 35.57073,
  35.57835, 35.4939, 35.47406, 35.44277, 35.49787, 35.5371, 35.53245,
  35.50846, 35.50856, 35.54753, 35.5425, 35.52124, 35.55447, 35.54584, NA,
  35.54584, 35.501794285714, 35.518311428571, 35.548558571429,
  35.575085714286, 35.581642857143, 35.5323, NA, 35.5323, 35.53248, 35.5421,
  35.58164, 35.6131, 35.6353, 35.6517, 35.62878, 35.57892, 35.52645,
  35.4939, 35.4373, 35.45375, NA, 35.45375, 35.44395, 35.40994, 35.38386,
  35.3856, 35.44693, 35.42294, 35.37843, 35.367, 35.43783, 35.4898, 35.536,
  35.5613, 35.62804, 35.69034, 35.7543, NA, 35.7543, 35.827, 35.89356,
  35.97476, 35.9896, 36.04994, 36.0999, 36.13665, 36.15147, 36.18517,
  36.22937, 36.3212, 36.3716, 36.421, 36.51924, 36.6204, 36.72534, 36.7883,
  36.89417, 36.95233, 36.97945, 37.03506, 37.0953, 37.1609, 37.19867,
  37.26534, 37.2403, 37.2536, 37.28674, 37.30157, 37.373, 37.36843, 37.3838,
  37.3172, 37.30294, 37.2782, 37.2362, 37.14656, 37.11867, 37.10025,
  37.0504, 37.06917, 37.04075, 37.08744, 37.07106, 36.97664, 36.95682,
  36.9543, 36.9009, 36.79814, 36.73255, 36.69057, 36.6603, 36.60535,
  36.60766, 36.61825, 36.7059, 36.76945, 36.8042, 36.8353, 36.8517,
  36.88224, 36.91335, 36.96165, 36.9529, 36.99273, 37.05636, NA, 37.05636,
  37.06547, 37.128, 37.1774, NA, 37.1774, 37.23775, 37.31393, 37.37434,
  37.45567, 37.5449, 37.6315, 37.7233, 37.768, 37.81797, NA, 37.81797,
  37.8433, 37.8765, 37.9448, 38.00514, 38.1127, 38.1877, 38.29153, 38.386,
  38.44586, 38.5508, NA, 38.5508, 38.64213, 38.7487, 38.8405, 38.98163,
  39.06707, 39.14517, 39.21504, 39.27538, 39.32, 39.374, 39.45626, 39.5004,
  39.5895, 39.6581, 39.74126, 39.7192, 39.7101, 39.7614, 39.8583, 39.8364,
  39.8737, 39.83027, 39.8985, 39.96047, 40.01557, 40.0722, 40.19117,
  40.2414, 40.30904, 40.3589, 40.4427, 40.44525, 40.5193, 40.5582, 40.61503,
  40.62825, 40.6781, 40.7332, 40.7568, 40.78086, 40.81766, 40.8827, 40.9629,
  40.99417, 41.00004, 41.0169, 41.09343, 41.13174, 41.08935, 41.0538,
  41.0681, 41.0619, 41.01425, 40.95605, 40.86274, 40.80145, 40.7391, 40.745,
  40.764, 40.7919, 40.82845, 40.8815, 40.8815, 40.8449, 40.7733, 40.8169,
  40.89297, 40.94387, 40.9879, 41.0655, 41.133, 41.133, 41.08314, 41.05687,
  41.04463, 41.04087, 41.0161, 40.984, 41.07624, 41.2074, 41.2772, 41.36155,
  41.3932, 41.33304, 41.3526, 41.30135, 41.2564, 41.256, 41.31004, 41.3222,
  41.3186, NA, 37.85853, 37.90415, 37.94875, 38.00496, 38.0653, 38.1147,
  38.17765, 38.19137, 38.13684, 38.0708, 37.98846, 37.9439, 37.94715,
  37.99283, 37.9772, 37.89215, 37.84697, 37.7709, 37.70415, 37.69363,
  37.6809, 37.67557, 37.7228, 37.76115, 37.83723, 37.89856, 37.8697,
  37.8319, 37.81, 37.85853, NA, 34.1288, 34.13, 34.14425, 34.21246,
  34.26063, 34.29572, 34.3613, 34.41486, 34.46212, 34.50205, 34.5088,
  34.52923, 34.4971, 34.4519, 34.38843, 34.3312, 34.3038, 34.23294, 34.2215,
  34.15704, 34.11677, NA, 33.19525, 33.10304, 33.071, 33.03998, 32.98507,
  32.9624, 32.9011, 32.9186, 32.9166, 32.86107, 32.8186, 32.78185, 32.74743,
  32.77477, 32.76504, 32.74626, 32.69648, 32.7647, 32.81505, 32.8685,
  32.90356, 32.9628, 32.9886, 33.02905, 33.0894, 33.12875, 33.17813,
  33.20437, 33.29357, 33.34564, 33.38923, 33.36837, 33.42716, 33.42342,
  33.4157, 33.42366, 33.498, 33.50556, 33.50838, 33.48126, 33.4437, 33.3793,
  33.33696, 33.27883, 33.2249, 33.25908, 33.3168, 33.36023, 33.41435,
  33.45424, 33.50147, 33.54082, 33.56444, NA, 33.56444, 33.58296, 33.63544,
  33.68794, 33.71696, 33.74544, 33.76868, 33.80686, 33.82355, NA, 33.81934,
  33.915125, 33.98935, 34.036445, 34.11286, 34.166795, 34.16677, 34.221275,
  34.2556, 34.28688, 34.26374, 34.33008, NA, 34.33008, 34.37762, 34.38536,
  34.3716, 34.3858, 34.41195, 34.38356, 34.33994, 34.3702, 34.3952,
  34.34016, 34.2693, 34.23356, 34.1365, 34.12292, 34.0861, 34.053, 34.00445,
  33.99376, 33.9752, 33.91907, 33.9441, 33.9671, 34.0001, 34.04822,
  34.08486, 34.11362, 34.03365, 33.9775, 33.916, NA, 33.916, 33.8086,
  33.70064, 33.64067, 33.57865, 33.53133, 33.50544, 33.46393, 33.4371, NA,
  33.4371, 33.40596, 33.36347, 33.3804, 33.41358, NA, 33.41358, 33.42265,
  33.43378, 33.38917, 33.35614, 33.2759, 33.2561, 33.19525, NA, 33.9594,
  33.92986, 33.87963, 33.8356, 33.7837, 33.74514, 33.70777, 33.67982,
  33.64066, 33.62163, 33.6121, 33.59472, 33.5824, 33.5929, 33.60345,
  33.62627, 33.6664, 33.6948, 33.69083, 33.6941, 33.66277, 33.63374,
  33.59238, 33.55275, 33.52156, 33.48416, 33.45405, 33.41894, 33.39887,
  33.39445, 33.3744, 33.356, 33.36386, 33.37676, 33.3913, 33.36117,
  33.31764, 33.28973, 33.26453, 33.24715, 33.25375, 33.25646, 33.2508,
  33.2803, 33.28415, 33.25682, 33.22174, 33.1771, 33.12187, 33.10563,
  33.10945, 33.096, 33.07983, 33.057, 33.02246, 32.99788, 32.9666, NA,
  32.9666, 32.97265, 32.97146, 32.94636, 32.9358, 32.92356, 32.9001, 32.884,
  NA, 32.884, 32.87512, 32.85504, 32.85327, 32.85714, 32.8265, 32.8255,
  32.81273, 32.77642, 32.7508, 32.71957, 32.68277, 32.66102, 32.70065,
  32.73916, 32.71017, 32.66274, 32.6165, 32.57464, 32.58866, 32.54066,
  32.4949, 32.47147, 32.48435, 32.47824, 32.4503, 32.4269, 32.36724,
  32.38063, 32.31817, 32.25293, 32.21278, 32.17984, 32.14473, 32.0828,
  32.04658, 31.9875, 31.93395, 31.896, 31.85135, 31.79495, 31.7626, 31.7068,
  31.66774, 31.63648, 31.61422, 31.60087, 31.597, 31.5585, 31.5211, 31.4793,
  31.4475, 31.4107, 31.35214, 31.39794, 31.3779, 31.4008, 31.45384,
  31.45224, 31.46176, 31.46793, 31.46298, 31.43956, 31.41114, 31.38718,
  31.36544, 31.35703, 31.3592, 31.34968, 31.32734, 31.29388, 31.2715,
  31.24366, 31.22975, 31.23928, 31.2237, 31.18857, 31.16183, 31.1473,
  31.13118, 31.1011, 31.08558, 31.08115, 31.06614, 31.0394, 31.00988,
  30.9865, 31.00936, 31.0674, 31.10474, 31.11082, 31.13424, 31.16712,
  31.1978, 31.23185, 31.2759, 31.30995, 31.36855, 31.40764, 31.44395,
  31.48975, 31.5204, 31.54945, 31.5439, 31.55345, 31.57187, 31.59644,
  31.6332, 31.63762, 31.62028, 31.58066, 31.5661, 31.55938, 31.5845,
  31.6118, 31.6436, 31.65525, 31.68318, 31.68434, 31.70166, 31.70733,
  31.7219, 31.69793, 31.65778, 31.61487, 31.58423, 31.5268, 31.49055,
  31.45203, 31.41743, 31.37333, 31.32365, 31.29793, 31.2689, 31.27776,
  31.27047, 31.2493, 31.21976, 31.1824, 31.1629, 31.16186, 31.17307,
  31.17926, 31.20936, 31.23225, 31.23287, 31.2346, 31.23747, 31.2459,
  31.25374, 31.22083, 31.23707, 31.28178, 31.31084, 31.31756, 31.3309,
  31.35262, 31.3571, 31.38285, 31.38958, 31.42416, 31.42744, 31.41623,
  31.42173, 31.44734, 31.48414, 31.51817, 31.5589, 31.608, 31.6454, 31.6884,
  31.72027, 31.74374, 31.7555, 31.79123, 31.81016, 31.852, 31.87373,
  31.90445, 31.9491, 31.98764, 32.0445, 32.0629, 32.0769, 32.13393,
  32.18804, 32.24826, 32.2148, 32.17915, 32.1714, 32.19038, 32.2077,
  32.24008, 32.26685, 32.29473, 32.3344, 32.3857, 32.4225, 32.4643, 32.5073,
  32.5391, 32.53958, 32.5267, 32.53055, 32.52658, 32.5204, 32.4797,
  32.48968, 32.5047, 32.5253, 32.50403, 32.4917, 32.52015, 32.5212, 32.5597,
  32.57036, 32.5927, 32.62446, 32.64674, 32.669, 32.68733, 32.70066,
  32.73526, 32.78103, 32.84745, 32.8743, 32.88888, 32.9341, 33.0067,
  33.04685, 33.07086, 33.10666, 33.11843, 33.138, 33.1776, 33.16318,
  33.1409, 33.11253, 33.0662, 33.0109, 32.97013, 32.93667, 32.9233, 32.8871,
  32.8665, 32.85868, 32.8547, 32.86246, 32.8702, 32.8696, 32.8472, 32.8176,
  32.77406, 32.7423, 32.70497, 32.67988, 32.6581, 32.63636, 32.61353,
  32.5868, 32.5628, 32.5863, 32.60257, 32.61932, 32.6511, 32.6812, 32.70125,
  32.723, 32.7548, 32.771, 32.78166, 32.7711, 32.73826, 32.74057, 32.7172,
  32.68042, 32.6553, 32.62523, 32.58567, 32.5673, 32.5495, 32.57852,
  32.6053, 32.6326, 32.6627, 32.6756, 32.6996, 32.7409, 32.73135, 32.78218,
  32.7783, 32.80405, 32.8627, 32.8917, 32.94306, 32.9927, 33.03507,
  33.06853, 33.08918, 33.1288, 33.1455, 33.17456, 33.17627, 33.18636,
  33.1747, 33.20653, 33.24554, 33.29358, 33.28467, 33.2529, 33.21445,
  33.1871, 33.1576, 33.16824, 33.17333, 33.18664, 33.22177, 33.253,
  33.27976, 33.3233, 33.36174, 33.3522, 33.3321, 33.32424, 33.3181,
  33.34202, 33.35256, 33.3743, 33.39374, 33.42607, 33.4333, 33.4383,
  33.4751, 33.49566, 33.52018, 33.5112, 33.4844, 33.4509, 33.447, 33.4152,
  33.40623, 33.44805, 33.46473, 33.47973, 33.5199, 33.52494, 33.5372,
  33.55895, 33.5801, 33.54494, 33.52653, 33.53594, 33.57495, 33.6039,
  33.6429, 33.66793, 33.68237, 33.73923, 33.77273, 33.7956, 33.83408,
  33.85915, 33.8886, 33.9181, 33.93028, 33.9274, 33.9229, 33.9022, 33.91663,
  33.94892, 33.9667, 33.96276, NA, 34.65568, 34.6233, 34.57307, 34.56467,
  34.53063, 34.52006, 34.48216, 34.4415, 34.38684, 34.33833, 34.35166,
  34.32152, 34.28248, 34.268, 34.24627, 34.219, 34.24524, 34.26206,
  34.28043, 34.29436, 34.30445, 34.32343, 34.339, 34.3691, 34.4098, 34.4249,
  34.4684, 34.4812, 34.51246, 34.57717, 34.6039, 34.61555, 34.65235,
  34.6529, NA, 33.24446, 33.21937, 33.2043, 33.20435, 33.2278, 33.2529,
  33.1637, 33.1653, 33.1519, 33.13744, 33.16647, 33.15686, 33.1418,
  33.15357, 33.16527, 33.1017, 33.0632, 33.01916, 32.97346, 32.9333,
  32.88814, 32.88432, 32.8268, 32.84083, 32.823, 32.80128, 32.7924,
  32.75443, 32.73156, 32.74053, 32.72327, 32.7088, 32.73615, 32.7016,
  32.7301, 32.748, 32.7363, 32.6872, 32.6548, 32.63308, 32.59403, 32.56784,
  32.55834, 32.551, 32.54702, 32.533, 32.55084, 32.56757, 32.581, 32.59773,
  32.61613, 32.59987, 32.62157, 32.64337, 32.6785, 32.69308, 32.70813,
  32.74666, 32.73264, 32.74655, 32.78233, 32.8152, 32.82523, 32.80398,
  32.7666, 32.7621, 32.78778, 32.83127, 32.81894, 32.81053, 32.78987,
  32.7999, 32.7915, 32.81827, 32.7881, 32.81766, 32.87353, 32.92037,
  32.9795, 33.05313, NA, 40.30863, 40.30863, 40.30863, 40.30863, 40.30863,
  40.318, 40.318, 40.31566, 40.31566, 40.32737, 40.28287, 40.28287, 40.2009,
  40.1681, 40.1681, 40.22666, 40.2782, 40.3227, 40.3695, NA, 40.16577,
  40.1072, 40.0463, 39.98075, 39.9011, 39.8168, 39.78167, 39.7278, 39.6833,
  39.61304, 39.51, 39.40695, 39.3273, 39.2711, 39.1938, 39.1048, 39.01114,
  38.9245, 38.86828, 38.86828, 38.8027, 38.80036, 38.7582, 38.6856,
  38.71136, 38.7418, 38.7418, 38.8987, 38.98303, 38.9643, 38.8472, NA,
  38.85657, 38.83314, 38.81675, 38.8964, 38.9245, 38.8964, 38.98303,
  39.0088, 38.99475, NA, 38.8261, 38.74883, 38.65983, 38.55913, 38.52165,
  38.40924, 38.32258, 38.2336, 38.15395, 38.04856, 37.95956, 37.89867,
  37.8729, 37.8448, 37.83543, 37.7511, 37.7511, 37.89164, NA, 37.8846,
  37.83543, 37.6879, 37.65744, 37.72536, 37.80265, 37.901, 38.0228, 38.1797,
  38.24763, 38.29916, 38.3577, 38.41626, NA, 37.7675, 37.65275, 37.57546,
  37.4209, 37.41152, 37.34126, 37.2499, 37.1375, 37.0485, 36.93843, 36.8869,
  36.8377, 36.8377, 36.9267, 36.9267, 37.01338, 37.09535, 37.0532, 36.98293,
  36.89627, 36.87754, 36.7979, 36.76278, 36.80728, 36.826, 36.8869,
  36.86583, 36.83304, NA, 36.8985, 36.8912, 36.8657, 36.83293, 36.81107,
  36.76918, 36.73457, 36.69996, 36.65624, 36.6271, 36.6016, 36.55787,
  36.5269, 36.49776, 36.47043, 36.43765, 36.40486, 36.3739, 36.36296,
  36.35385, 36.34657, 36.3229, 36.3138, 36.28464, 36.2482, 36.2318, 36.2063,
  36.1717, 36.14255, 36.097, 36.08244, 36.0533, 36.0442, 36.08426, 36.1225,
  36.1735, 36.1972, 36.22088, 36.22088, 36.22088, 36.22088, 36.22088,
  36.22088, 36.24456, 36.2646, 36.29557, 36.3593, 36.383, 36.4176, 36.45586,
  36.49594, 36.52326, 36.52326, 36.5451, 36.5615, 36.5925, 36.63256,
  36.68356, 36.7364, 36.7546, 36.79104, 36.83658, NA, 35.71994, 35.73087,
  35.73087, 35.76184, 35.77823, 35.8165, 35.842, 35.8839, 35.91667,
  35.92396, 35.92396, 35.91303, 35.89117, 35.8693, 35.8693, 35.85656,
  35.82924, 35.82924, 35.8438, 35.8602, 35.8693, 35.9112, 35.93853, 35.9713,
  36.00957, 36.0205, 36.0551, 36.0624, 36.0369, 36.00775, 35.98225, 35.9531,
  35.9258, 35.8857, 35.8365, 35.80556, 35.76913, 35.7345, 35.69626,
  35.65983, 35.6325, 35.6052, 35.57968, NA, 36.0606, 36.097, 36.1298,
  36.1298, 36.1389, 36.15895, 36.1735, 36.18627, 36.18627, 36.17716,
  36.19173, 36.1553, 36.11887, 36.08244, 36.0606, 36.02597, 35.99864,
  35.97496, 35.9531, 35.9203, 35.90575, 35.8839, 35.86385, 35.82924,
  35.78187, 35.7673, 35.7673, 35.72723, 35.68898, 35.64526, 35.607,
  35.57786, 35.556, 35.53596, 35.51046, 35.48496, 35.46128, 35.4631,
  35.49224, 35.51046, 35.52867, 35.55236, 35.5633, 35.60154, 35.60154,
  35.60154, 35.60154, 35.5742, 35.55236, 35.55236, 35.53596, 35.52867,
  35.52867, NA, 35.7746, 35.791, 35.8092, 35.8092, 35.8092, 35.791, 35.791,
  35.791, 35.7746, 35.76184, 35.7418, 35.74, 35.72723, 35.72723, 35.72723,
  35.72723, 35.7418, 35.74727, 35.74727, 35.74727, 35.72176, NA, 35.811,
  35.79645, 35.791, 35.80556, 35.811, 35.83106, 35.8438, 35.84563, 35.8165,
  35.7837, 35.7837, 35.7837, 35.75455, 35.71994, 35.68533, 35.64526,
  35.60154, 35.58514, 35.54507, 35.4959, 35.44306, 35.40845, 35.3793,
  35.34105, 35.30826, 35.29187, 35.25726, 35.23904, 35.22447, 35.22447,
  35.2026, 35.19897, 35.16254, 35.13703, 35.13703, 35.13703, 35.15525,
  35.19715, 35.23358, 35.26637, 35.2864, 35.321, 35.3465, 35.3465, 35.34287,
  35.32648, 35.32648, 35.32648, 35.3192, 35.30826, 35.30826, 35.31555,
  35.31373, 35.32648, 35.35927, 35.352, 35.3283, 35.30826, 35.2864, 35.2591,
  35.22265, 35.1844, 35.15525, 35.12792, 35.11153, 35.09696, 35.09696, NA,
  35.58332, 35.55782, 35.5378, 35.4977, 35.4649, 35.4449, 35.4449, 35.4303,
  35.40663, 35.3793, 35.37566, NA, 35.58514, 35.54507, 35.50317, 35.4704,
  35.43577, 35.38295, 35.3356, 35.29734, 35.26637, 35.24997, 35.219,
  35.18257, 35.15707, 35.1243, 35.1243, 35.10242, 35.0678, 35.02045,
  34.98038, 34.94577, 34.91662, 34.87837, 34.8292, 34.78364, 34.7545,
  34.73264, 34.70714, 34.6798, 34.65796, 34.627, NA, 36.86026, 36.88394,
  36.90033, 36.9331, 36.9386, 36.92037, 36.8912, 36.87847, 36.84933,
  36.81654, 36.78375, 36.76553, 36.74367, 36.71453, 36.68356, 36.6526,
  36.63985, 36.6198, 36.6125, 36.6125, 36.60523, 36.5943, 36.57244,
  36.53237, 36.4923, 36.4504, 36.42308, 36.383, 36.36114, 36.3229, 36.3229,
  36.3065, 36.3065, 36.3338, 36.3393, 36.3156, 36.3156, 36.2737, 36.21906,
  36.1899, 36.1571, 36.12434, 36.0952, 36.04783, 36.00775, 35.9713, 35.9458,
  35.9349, NA, 36.6282, 36.63443, 36.6563, 36.6719, 36.68856, 36.7073,
  36.7385, 36.77287, 36.8166, 36.85823, 36.8832, 36.8936, 36.8936, 36.878,
  36.8655, 36.8426, 36.81555, 36.7656, 36.74685, 36.7229, 36.7229, 36.7229,
  36.7177, 36.7104, 36.7333, 36.74685, 36.78016, 36.78016, 36.78016, 36.802,
  36.7968, 36.7708, 36.73956, 36.7073, 36.68023, 36.66045, NA, 36.8832,
  36.85927, 36.8197, 36.7864, 36.74997, 36.7177, 36.67607, 36.6417,
  36.60633, 36.5595, 36.5241, 36.4731, 36.44186, 36.40647, 36.369, 36.3305,
  36.3024, 36.26907, 36.2368, 36.2108, 36.2087, 36.2108, 36.18996, 36.1858,
  36.1629, 36.15978, 36.15978, 36.18268, 36.20454, 36.23993, 36.27116,
  36.2847, 36.3024, 36.3024, 36.3024, 36.2899, 36.2805, 36.2805, 36.2805,
  36.2722, 36.3034, 36.33777, 36.40855, 36.47726, 36.5366, 36.6011,
  36.66774, 36.70417, 36.74164, 36.76975, 36.802, 36.82284, NA, 36.27636,
  36.25138, 36.23264, 36.20037, 36.15874, 36.1244, 36.089, 36.04736,
  36.0005, 35.9516, 35.89435, 35.85583, 35.8121, 35.78505, 35.7736, 35.758,
  35.7455, 35.72676, 35.70906, 35.69865, 35.6841, 35.6643, 35.63724, 35.606,
  35.57895, 35.54772, 35.50817, 35.45612, 35.41136, 35.3916, 35.36244,
  35.33538, 35.3031, 35.26356, 35.24378, 35.21463, 35.17195, 35.13136,
  35.12095, 35.1095, 35.1324, 35.1345, 35.12095, NA, 36.14833, 36.11294,
  36.0744, 36.05777, 36.0411, 36.01405, 36.0026, 36.0151, 35.98907,
  35.97346, 35.9516, 35.9516, NA, 36.216, 36.2014, 36.17435, 36.15457,
  36.1369, 36.10877, 36.08587, 36.05777, 36.02238, 35.98803, 35.9672,
  35.93806, 35.90475, 35.8912, 35.87457, 35.85687, 35.8215, 35.7944, 35.758,
  35.72988, 35.70906, 35.6924, 35.68512, 35.68512, 35.68512, 35.65598,
  35.6466, 35.66222, 35.66222, 35.66222, 35.64973, 35.62163, 35.58728,
  35.5623, 35.5623, 35.5394, 35.51753, 35.49256, 35.46237, 35.4405,
  35.42073, 35.38846, 35.36036, 35.33017, 35.29166, 35.25523, 35.25523,
  35.25523, 35.2719, 35.28854, 35.31977, 35.37285, 35.41865, 35.44675, NA,
  35.52503, 35.5094, 35.4782, 35.43916, 35.40793, 35.37046, 35.33923,
  35.3002, 35.2596, 35.22056, 35.1659, 35.15187, 35.13, 35.1425, 35.1456,
  35.11595, 35.0894, 35.04257, 35.01134, 34.9879, 34.9645, 34.91922,
  34.87707, 34.8318, 34.7865, 34.72093, 34.646, NA, 35.53752, 35.5016,
  35.43447, 35.397, 35.40793, 35.42823, 35.37982, 35.35016, 35.29083,
  35.2752, 35.2752, 35.2752, 35.22056, 35.19246, 35.1706, 35.15343, 35.1347,
  35.1019, 35.0691, 35.0535, 35.0301, 34.99573, 34.9598, 34.92547, 34.87863,
  34.8396, 34.80212, 34.76777, 34.70844, 34.67565, 34.62257, 34.6054,
  34.58665, NA, 34.96138, 34.9364, 34.91454, 34.8802, 34.8599, 34.83803,
  34.83335, 34.83335, 34.81617, 34.78495, 34.7631, 34.7256, 34.685,
  34.64442, 34.6085, 34.5648, 34.5164, 34.46955, 34.43364, 34.39617,
  34.33996, 34.3103, 34.29, 34.29, 34.2619, 34.2416, 34.2291, 34.21193,
  34.21193, 34.2244, NA, 34.29, 34.2619, 34.2369, 34.19163, 34.14167,
  34.0917, 34.11824, 34.1042, 34.048, 33.9902, 33.95118, 33.9106, 33.87936,
  33.82783, 33.781, 33.81534, 33.81534, 33.8216, 33.845, 33.781, 33.7357,
  33.7076, 33.6748, 33.65764, NA, 35.2518, 35.23306, 35.20495, 35.16904,
  35.15343, 35.0894, 35.04726, 35.0004, 34.94264, 34.8911, 34.8474, 34.7912,
  34.75996, 34.71, 34.67565, 34.61476, 34.55855, 34.49297, 34.46487,
  34.43364, 34.41334, 34.3712, 34.33996, 34.33684, 34.3025, 34.27594,
  34.2416, 34.1651, 34.10888, 34.0074, 33.9465, 33.91527, 33.8856, 33.82315,
  33.8091, NA, 34.61007, 34.64442, 34.64442, 34.63505, 34.63505, 34.6741,
  34.6741, 34.63505, 34.61476, 34.61476, NA, 35.20964, 35.18778, 35.16904,
  35.15187, 35.1659, 35.17997, 35.1956, 35.19246, 35.1706, 35.19246,
  35.2268, 35.2674, 35.3205, 35.3205, 35.3033, 35.27365, 35.24555, 35.1987,
  35.15343, 35.11595, 35.08473, 35.06443, 35.04257, 35.0176, 34.98324,
  34.94733, NA, 34.70844, 34.75684, 34.8146, 34.8146, 34.78963, 34.774,
  34.774, 34.81305, 34.86614, 34.9114, 34.93484, 34.99105, 34.99417,
  35.03477, 35.0613, 35.0894, 35.1097, 35.1097, 35.1097, 35.08785, 35.08785,
  NA, 35.13563, 35.13355, 35.09608, 35.09608, 35.15645, 35.196, 35.2293,
  35.1981, 35.15645, 35.20225, 35.23764, 35.24597, 35.20433, 35.1481,
  35.08775, 35.08775, 35.06485, 35.0128, 34.99615, 34.9774, 35.00447,
  35.01072, 35.08567, 35.1169, 35.16477, 35.18976, 35.22307, 35.2897,
  35.32715, 35.4636, NA, 34.98157, 34.9316, 34.84418, 34.77964, 34.75257,
  34.7172, 34.6922, 34.6214, 34.5444, 34.51733, 34.46737, 34.44863, NA,
  34.62047, 34.5673, 34.49443, 34.43198, 34.4049, 34.382, 34.3154, 34.28625,
  34.28625, 34.28625, 34.34038, 34.40908, 34.43406, 34.4882, 34.4965,
  34.5215, 34.5881, 34.65056, 34.69637, 34.72967, 34.72967, 34.74633,
  34.75466, 34.7859, 34.8317, 34.86083, 34.86083, 34.92536, 34.9795,
  35.01697, 35.01697, 34.98157, 35.01905, NA, 34.48194, 34.36328, 34.31956,
  34.24045, 34.1988, 34.1905, NA, 34.293, 34.14885, 34.1176, 34.0843,
  34.051, 34.02186, 33.96565, 33.9469, 34.12, NA, 33.4785, 33.54096,
  33.56594, 33.6263, 33.6971, 33.7429, 33.78037, 33.83033, 33.88238,
  33.95108, NA, 32.92683, 32.97887, 33.0434, 33.10586, 33.15582, 33.14125,
  33.1683, 33.2287, 33.28073, 33.29947, 33.35568, 33.42438, 33.42438,
  33.42438, 33.5264, 33.57843, 33.67836, 33.7096, 33.7554, 33.7554, 33.7887,
  33.7887, 33.7887, 33.79494, 33.79494, NA, 33.61323, 33.5848, 33.54963,
  33.51448, 33.51675, 33.51513, 33.51244, 33.50413, 33.51422, 33.47522,
  33.4334, 33.3765, 33.3146, 33.2694, 33.23937, 33.2114, 33.20077, 33.1645,
  33.12936, 33.111, 33.08415, 33.07238, 33.0355, 33.02208, 33.0522,
  33.07725, 33.10293, 33.137, 33.18275, 33.1782, 33.1893, 33.1686, 33.14178,
  33.10604, 33.04295, 32.9966, 32.95306, 32.90283, 32.86764, 32.8525,
  32.8441, 32.84065, 32.8445, 32.82884, 32.79646, 32.7786, 32.783, 32.78795,
  32.78845, 32.8241, 32.8514, 32.87034, 32.85688, 32.84342, 32.82388, NA,
  32.84975, 32.82137, 32.78236, 32.7489, 32.69594, 32.65694, 32.6246,
  32.585, 32.59174, 32.60015, 32.5505, 32.5009, 32.46404, 32.41658,
  32.37246, 32.32055, 32.29043, 32.2771, 32.2436, 32.2106, 32.1721,
  32.15205, 32.16327, 32.18394, 32.17283, 32.126, 32.116, 32.1283, 32.1445,
  32.12447, 32.10223, 32.09672, 32.08113, 32.0499, 32.0074, 31.9728,
  31.94373, 31.9342, 31.89957, 31.87385, 31.8259, 31.80357, 31.7879,
  31.77558, 31.7605, 31.7314, 31.6901, 31.67503, 31.6588, 31.64036,
  31.64028, 31.62458, 31.58443, 31.54372, 31.4974, 31.48797, 31.47125, NA,
  32.0962, 32.14206, 32.1572, 32.1433, 32.1272, 32.11668, 32.13518,
  32.15697, 32.2156, 32.2703, 32.31273, 32.32843, 32.31175, 32.27106,
  32.2566, NA, 33.1155, 33.13343, 33.16025, 33.1698, 33.13077, 33.1057,
  33.11415, 33.07175, 33.06568, 33.05287, 33.01994, 32.99825, 32.99997, NA,
  33.11614, 33.16303, 33.18698, 33.23215, 33.25105, 33.2867, 33.33016,
  33.3418, 33.40043, 33.4267, 33.4173, 33.3939, 33.40735, 33.418, 33.45656,
  33.4734, 33.46784, 33.4506, 33.4674, 33.47864, NA, 33.39213, 33.3692,
  33.3368, 33.3094, 33.2771, 33.24915, 33.21953, 33.171, 33.1503, 33.138,
  33.12844, 33.12003, 33.10163, 33.07657, 33.05252, 33.02065, 32.97705,
  32.96247, 32.94845, 32.94004, NA, 35.56646, 35.54877, 35.4936, 35.45612,
  35.39367, 35.37597, 35.351, 35.3385, 35.3135, 35.28437, 35.2573, 35.2365,
  35.2063, 35.18132, 35.1553, 35.13552, 35.11065, NA, 39.8387, 39.8119,
  39.77313, 39.7367, 39.7031, 39.66953, 39.63816, 39.6366, 39.63134,
  39.61485, 39.61103, 39.57298, 39.55283, 39.5072, 39.53097, 39.4974,
  39.4981, 39.49283, 39.4436, 39.4584, 39.4181, 39.42917, 39.41866, 39.4223,
  39.3798, 39.35153, 39.31878, 39.30775, 39.30237, 39.29118, 39.2411,
  39.20303, 39.19564, 39.20025, 39.15406, 39.12488, 39.1345, 39.0612,
  39.0566, 39.09914, 39.14827, 39.1892, 39.2304, 39.26994, 39.2969, 39.3311,
  39.37195, 39.4145, 39.42655, 39.4618, 39.53288, 39.56198, 39.5767, 39.593,
  39.6512, 39.6737, 39.67243, 39.6232, 39.60918, 39.65555, 39.69746,
  39.73775, 39.7841, 39.85126, 39.84986, NA, 39.95617, 39.965, 40.00754,
  39.9987, 39.95618, NA, 39.8577, 39.8658, 39.88593, 39.8853, 39.86065, NA,
  39.6726, 39.6918, 39.6694, 39.66277, 39.6726, 39.66804, NA, 39.17945,
  39.1414, 39.1948, 39.2322, 39.17945, NA, 39.337, 39.3026, 39.27514,
  39.2231, 39.27233, 39.29247, 39.34666, NA, 38.5, 38.5, 40.5, 40.5, 38.5,
  NA)

"jpn.b" <-
list(start = c(1, 436, 537, 550, 597, 695, 720, 742, 796, 807, 816, 832,
	 853, 857, 890, 919, 927, 941, 958, 1026, 1031, 1042, 1054, 1147,
	 1178, 1200, 1254, 1264, 1277, 1308, 1318, 1324, 1333, 1391, 1400,
	 1773, 1808, 1889, 1909, 1941, 1951, 1970, 1984, 2013, 2076, 2120,
	 2174, 2196, 2264, 2276, 2307, 2356, 2393, 2446, 2490, 2503, 2558,
	 2586, 2620, 2651, 2676, 2712, 2723, 2750, 2772, 2803, 2816, 2850,
	 2857, 2867, 2878, 2904, 2960, 3018, 3034, 3048, 3069, 3090, 3108,
	 3174, 3180, 3186, 3193, 3199, 3207), end = c(435, 536, 549, 596,
	 694, 719, 741, 795, 806, 815, 831, 852, 856, 889, 918, 926, 940,
	 957, 1025, 1030, 1041, 1053, 1146, 1177, 1199, 1253, 1263, 1276,
	 1307, 1317, 1323, 1332, 1390, 1399, 1772, 1807, 1888, 1908, 1940,
	 1950, 1969, 1983, 2012, 2075, 2119, 2173, 2195, 2263, 2275, 2306,
	 2355, 2392, 2445, 2489, 2502, 2557, 2585, 2619, 2650, 2675, 2711,
	 2722, 2749, 2771, 2802, 2815, 2849, 2856, 2866, 2877, 2903, 2959,
	 3017, 3033, 3047, 3068, 3089, 3107, 3173, 3179, 3185, 3192, 3198,
	 3206, 3212),
     x = structure(
	 .Data = c(139.7815, 145.8293, 140.7827, 141.9366, 140.6682,
	     140.9153, 140.124, 140.8681, 138.2175, 140.124, 136.9506,
	     138.2175, 136.4876, 136.9506, 134.9838, 136.9143, 134.8816,
	     135.466, 134.2742, 134.8816, 133.4576, 134.2742, 132.1682,
	     133.4576, 131.9305, 132.1862, 130.935, 132.0693, 132.0693,
	     134.1967, 134.1967, 134.8136, 134.8136, 135.4648, 135.4648,
	     136.1614, 136.0392, 138.2294, 138.2294, 138.5008, 138.5008,
	     139.094, 139.094, 139.6936, 139.6936, 141.4854, 138.3064,
	     138.7125, 134.5984, 135.0075, 132.2739, 134.2153, 134.2153,
	     134.7032, 134.2374, 134.6106, 132.7126, 134.2574, 132.1446,
	     132.7126, 132.0103, 132.1856, 132.1856, 132.36, 130.9776,
	     131.9969, 131.97, 132.0725, 129.3387, 132.0254, 129.238,
	     129.5095, 128.6105, 129.1508, 140.0681, 141.588, 140.6685,
	     141.5441, 139.9773, 140.7183, 140.2878, 140.856, 139.6083,
	     140.2848, 139.2335, 140.7446, 139.335, 140.2278, 139.615,
	     140.8565, 138.6698, 139.7176, 138.9318, 139.8133, 138.1368,
	     139.0297, 138.8839, 139.089, 137.3965, 138.1414, 138.3805,
	     139.2552, 137.847, 138.7048, 136.8929, 137.8509, 137.3602,
	     137.7689, 136.3801, 136.7719, 135.5236, 136.9177, 134.318,
	     134.6147, 134.9857, 135.4797, 135.0247, 135.7198, 135.4797,
	     135.8643, 135.7667, 136.2079, 135.6964, 136.0322, 136.6003,
	     137.5473, 136.04, 136.5945, 133.2488, 134.4931, 133.3659,
	     133.457, 131.7884, 133.2436, 132.1294, 132.2179, 133.5846,
	     134.3057, 133.6236, 134.1703, 132.4704, 133.6861, 130.8024,
	     131.8704, 130.7301, 131.3258, 130.1275, 130.7166, 130.4266,
	     130.8158, 130.0733, 130.5587, 129.6877, 130.1864, 136.3384,
	     136.4725, 131.1517, 131.8535, 131.4634, 131.5167, 131.4175,
	     131.4578, 131.2718, 131.353, 130.7774, 130.871, 130.1869,
	     130.2891, 130, 132),
	 .Dim = c(2, 85)),
     y = structure(
	 .Data = c(41.39286, 45.5241, 37.2372, 41.3243, 36.7393, 37.2372,
	     35.095, 36.7393, 34.58097, 35.57664, 34.50396, 34.8117,
	     34.4896, 35.03953, 33.45007, 34.4896, 34.45297, 34.68172,
	     34.62133, 34.7268, 34.44167, 34.65474, 33.95193, 34.44167,
	     33.94124, 33.95777, 33.9555, 34.81404, 34.81404, 35.6064,
	     35.501794285714, 35.581642857143, 35.4373, 35.6517, 35.367,
	     35.7543, 35.7543, 37.3838, 37.05636, 37.1774, 37.1774,
	     37.81797, 37.81797, 38.5508, 38.5508, 41.3932, 37.67557,
	     38.19137, 34.11677, 34.52923, 32.69648, 33.56444, 33.56444,
	     33.82355, 33.81934, 34.33008, 33.916, 34.41195, 33.4371,
	     33.916, 33.36347, 33.4371, 33.19525, 33.43378, 32.9666,
	     33.9594, 32.884, 32.97265, 30.9865, 33.9667, 34.219, 34.65568,
	     32.533, 33.2529, 40.1681, 40.3695, 38.6856, 40.16577, 38.81675,
	     39.0088, 37.7511, 38.8261, 37.65744, 38.41626, 36.76278,
	     37.7675, 36.0442, 36.8985, 35.57968, 36.0624, 35.46128,
	     36.19173, 35.72176, 35.8092, 35.09696, 35.84563, 35.37566,
	     35.58332, 34.627, 35.58514, 35.9349, 36.9386, 36.6282, 36.8936,
	     36.15978, 36.8832, 35.1095, 36.27636, 35.9516, 36.14833,
	     35.25523, 36.216, 34.646, 35.52503, 34.58665, 35.53752,
	     34.21193, 34.96138, 33.65764, 34.29, 33.8091, 35.2518,
	     34.61007, 34.6741, 34.94733, 35.3205, 34.70844, 35.1097,
	     34.9774, 35.4636, 34.44863, 34.98157, 34.28625, 35.01905,
	     34.1905, 34.48194, 33.9469, 34.293, 33.4785, 33.95108,
	     32.92683, 33.79494, 32.7786, 33.61323, 31.47125, 32.84975,
	     32.0962, 32.32843, 32.99825, 33.1698, 33.11614, 33.47864,
	     32.94004, 33.39213, 35.11065, 35.56646, 39.0566, 39.85126,
	     39.95617, 40.00754, 39.8577, 39.88593, 39.66277, 39.6918,
	     39.1414, 39.2322, 39.2231, 39.34666, 38.5, 40.5),
	 .Dim = c(2, 85)))

"jcity"<-
list(sapporo = list(x = 141.35, y = 43.05),
     asahikawa = list(x = 142.3667, y = 43.7667),
     kushiro = list(x = 144.3833, y = 42.9667),
     aomori = list(x = 140.75, y = 40.8167),
     morioka = list(x = 141.15, y = 39.7),
     akita = list(x = 140.1167, y = 39.7167),
     sendai = list(x = 140.8833, y = 38.25),
     yamagata = list(x = 140.25, y = 38.25),
     fukushima = list(x = 140.4667, y = 37.75),
     mito = list(x = 140.4667, y = 36.3667), 
     utsunomiya = list(x = 139.8667, y = 36.55),
     maebashi = list(x = 139.0667, y = 36.3833),
     urawa = list(x = 139.65, y = 35.85),
     chiba = list(x = 140.1167, y = 35.6),
     tokyo = list(x = 139.7667, y = 35.7),
     yokohama = list(x = 139.65, y = 35.45),
     niigata = list(x = 139.05,	y = 37.9167),
     toyama = list(x = 137.2167, y = 36.6833),
     kanazawa = list(x = 136.65, y = 36.5667),
     fukui = list(x = 136.2167, y = 36.0667),
     kofu = list(x = 138.5833, y = 35.65),
     nagoya = list(x = 136.9167, y = 35.1667),
     gifu = list(x = 136.75, y = 35.4167),
     shizuoka = list(x = 138.3833, y = 34.9667),
     nagano = list(x = 138.1833, y = 36.65),
     tsu = list(x = 136.5167, y = 34.7167),
     otsu = list(x = 135.8667, y = 35),
     kyoto = list(x = 135.75, y = 35),
     osaka = list(x = 135.5, y = 34.6667),
     kobe = list(x = 135.1667, y = 34.6833),
     nara = list(x = 135.8333, y = 34.6833),
     wakayama = list(x = 135.1833, y = 34),
     tottori = list(x = 134.2333, y = 35.5),
     matsue = list(x = 133.0667, y = 35.4667),
     okayama = list(x = 133.9167, y = 34.65),
     hiroshima = list(x = 132.45, y = 34.4),
     yamaguchi = list(x = 131.4833, y = 34.1667),
     tokushima = list(x = 134.5667, y = 34.0667),
     takamatsu = list(x = 134.05, y = 34.3333),
     matsuyama = list(x = 132.75, y = 33.8333),
     kochi = list(x = 133.55, y = 33.55),
     fukuoka = list(x = 130.4, y = 33.5833),
     saga = list(x = 130.3, y = 33.25),
     nagasaki = list(x = 129.9167, y = 32.8),
     kumamoto = list(x = 130.7167, y = 32.8),
     oita = list(x = 131.6, y = 33.2333),
     miyazaki = list(x = 131.4333, y = 31.9),
     kagoshima = list(x = 130.55, y = 31.6),
     naha = list(x = 131.1769, y = 39.18505))
