\name{kalseries}
\title{Repeated Measurements Models for Continuous Variables in the
Presence of Time-varying Covariates and with Frailty or Serial
Dependence}
\usage{
kalseries(response, times=NULL, intensity="exponential",
	depend="independence", mu=NULL, shape=NULL, density=F, ccov=NULL,
	tvcov=NULL, torder=0, interaction=NULL, pinitial=1, pdepend=NULL,
	pshape=1, preg=NULL, ptvc=NULL, pintercept=NULL, delta=NULL,
	transform="identity", link="identity", print.level=0,
	ndigit=10, gradtol=0.00001, steptol=0.00001, iterlim=100,
	fscale=1, typsiz=abs(p), stepmax=10*sqrt(p\%*\%p))
}
\alias{kalseries}
\alias{coefficients.kalseries}
\alias{deviance.kalseries}
\alias{fitted.kalseries}
\alias{residuals.kalseries}
\alias{print.kalseries}
\arguments{
\item{response}{A list of two column matrices with responses and
corresponding times for each individual, one matrix or dataframe of
response values, or an object of class, response (created by
\code{\link{restovec}}).}
\item{times}{When response is a matrix, a vector of possibly unequally
spaced times when they are the same for all individuals or a matrix of
times. Not necessary if equally spaced.}
\item{intensity}{The form of function to be put in the Pareto distribution.
Choices are exponential, Weibull, gamma, normal, logistic, Cauchy,
Student, log normal, log logistic, log Cauchy, log Student, and
gen(eralized) logistic.}
\item{depend}{Type of dependence. Choices are independence, Markov,
serial, and frailty.}
\item{mu}{A regression function for the location parameter. If there
are only time-constant covariates, give the initial estimates in preg;
if any covariates are time-varying, give all initial estimates in ptvc.}
\item{shape}{A regression function for the shape parameter. It must
return a vector with one value per observation.}
\item{density}{If TRUE, the density of the function specified in
\code{intensity} is used instead of the intensity.}
\item{ccov}{A vector or matrix containing time-constant baseline
covariates with one row per individual, a model formula using
vectors of the same size, or an object of class, tccov (created by
\code{\link{tcctomat}}).}
\item{tvcov}{A list of matrices with time-varying covariate values,
observed at the event times in \code{response}, for each individual
(one column per variable), one matrix or dataframe of such
covariate values, or an object of class, tvcov (created by
\code{\link{tvctomat}}). If a time-varying covariate is observed at arbitrary
time, \code{\link{gettvc}} can be used to find the most recent values for
each response and create a suitable list.}
\item{torder}{The order of the polynomial in time to be fitted.}
\item{interaction}{Vector of length equal to the number of
time-constant covariates, giving the levels of interactions between
them and the polynomial in time in the \code{linear model}.}
\item{pinitial}{An initial estimate for the initial parameter. (With
frailty dependence, this is the frailty parameter.)}
\item{pdepend}{An initial estimate for the serial dependence parameter.}
\item{pshape}{An initial estimate for the shape parameter of the
intensity function (except exponential intensity).}
\item{preg}{Initial parameter estimates for the regression model:
intercept, one for each covariate in \code{ccov}, and \code{torder} plus
sum(\code{interaction}).If a location function (mu) is supplied that
contains time-varying covariates, all initial estimates must be given
in ptvc.}
\item{ptvc}{Initial parameter estimates for the coefficients of the
time-varying covariates, as many as in \code{tvcov}. If a location
function (mu) is supplied that contains time-varying covariates, all
initial estimates must be given here.}
\item{pintercept}{The initial estimate of the intercept for the
generalized logistic intensity.}
\item{delta}{Scalar or vector giving the unit of measurement for each
response value, set to unity by default. For example, if a response is
measured to two decimals, delta=0.01. If the response has been
pretransformed, this must be multiplied by the Jacobian. This
transformation cannot contain unknown parameters. For example, with a
log transformation, \code{delta=1/y}. (The delta values for the
censored response are ignored.) The jacobian is calculated
automatically for the transform option.}
\item{transform}{Transformation of the response variable: \code{identity},
\code{exp}, \code{square}, \code{sqrt}, or \code{log}.}
\item{link}{Link function for the mean: \code{identity}, \code{exp},
\code{square}, \code{sqrt}, or \code{log}.}
\item{others}{Arguments controlling \code{\link{nlm}}.}
}
\description{
\code{kalseries} is designed to handle repeated measurements models with
time-varying covariates. The distributions have two extra parameters
as compared to the functions specified by \code{intensity} and are
generally longer tailed than those distributions. Dependence among
observations on a unit can be through frailty (a type of random effect)
or serial dependence over time.

Marginal and individual profiles can be plotted using
\code{\link{plot.profile}} and \code{\link{plot.iprofile}} and
residuals with \code{\link{plot.residuals}}.
}
\value{
A list of classes \code{kalseries} and \code{recursive} is returned.
}
\seealso{
\code{\link{carma}}, \code{\link{elliptic}}, \code{\link{gar}},
\code{\link{gettvc}}, \code{\link{gnlmm}}, \code{\link{gnlr}},
\code{\link{kalcount}}, \code{\link{kalsurv}}, \code{\link{read.list}},
\code{\link{restovec}}, \code{\link{rmna}}, \code{\link{tcctomat}},
\code{\link{tvctomat}}.
}
\examples{
# normal intensity, independence model
kalseries(y, intensity="normal", dep="independence", pshape=10)
# random effects
kalseries(y, intensity="normal", dep="frailty", pdep=0.5, psh=12)
# serial dependence
kalseries(y, intensity="normal", dep="serial", pinitial=0.6,
	pdep=0.6, psh=10)
# add time-constant variable
kalseries(y, intensity="normal", dep="serial", pinitial=0.9,
	pdep=0.9, psh=10, preg=c(-6,-5.5), ccov=treat)
# add time-varying variable
kalseries(y, intensity="normal", dep="serial", pinitial=0.6, pdep=0.9,
	psh=14, preg=c(-6,-4.8), ccov=treat,
	ptvc=c(-0.5,0), tvc=times2)
}
