\name{logitord}
\title{Ordinal Random Effects Models with Dropouts}
\usage{
logitord(y, id, out.ccov=NULL, drop.ccov=NULL, tvcov=NULL,
	out.tvcov=!is.null(tvcov), drop.tvcov=!is.null(tvcov),
	pout, pdrop, prand.out, prand.drop,
	random.out.int=T, random.out.slope=!is.null(tvcov),
	random.drop.int=T, random.drop.slope=!is.null(tvcov),
	binom.mix=5, fcalls=900, eps=0.0001, print.level=0)
}
\arguments{
\item{y}{A vector of binary or ordinal responses with levels 1 to k
and 0 indicating drop-out.}
\item{id}{Identification number for each individual.}
\item{out.ccov}{A vector, matrix, or model formula of time-constant
covariates for the outcome regression, with variables having the same
length as y.}
\item{drop.ccov}{A vector, matrix, or model formula of time-constant
covariates for the drop-out regression, with variables having the same
length as y.}
\item{tvcov}{One time-varying covariate vector.}
\item{out.tvcov}{Include the time-varying covariate in the outcome
regression.}
\item{drop.tvcov}{Include the time-varying covariate in the drop-out
regression.}
\item{pout}{Initial estimates of the outcome regression coefficients,
with length equal to the number of levels of the response plus the
number of covariates minus one.}
\item{pdrop}{Initial estimates of the drop-out regression coefficients,
with length equal to one plus the number of covariates.}
\item{prand.out}{Optional initial estimates of the outcome random
parameters.}
\item{prand.drop}{Optional initial estimates of the drop-out random
parameters.}
\item{random.out.int}{If TRUE, the outcome intercept is random.}
\item{random.out.slope}{If TRUE, the slope of the time-varying covariate
is random for the outcome regression (only possible if a time-varying
covariate is supplied and if out.tvcov and random.out.int are TRUE).}
\item{random.drop.int}{If TRUE, the drop-out intercept is random.}
\item{random.drop.slope}{If TRUE, the slope of the time-varying covariate
is random for the drop-out regression (only possible if a time-varying
covariate is supplied and if drop.tvcov and random.drop.int are TRUE).}
\item{binom.mix}{The total in the binomial distribution used to
approximate the normal mixing distribution.}
\item{fcalls}{Number of function calls allowed.}
\item{eps}{Convergence criterion.}
\item{print.level}{If 1, the iterations are printed out.}
}
\description{
\code{logitord} fits an longitudinal ordinal model in discrete time to
outcomes and a logistic model to the probability of dropping out using
a common random effect for the two.
}
\references{
Ten Have, T, Kunselman, A.R., Pulkstenis, E.P. and Landis, J.R.
(1998) Biometrics 54, 367--383, for the binary case.
}
\value{
A list of class \code{logitord} is returned.
}
\author{T.R. Ten Have and J.K. Lindsey}
\examples{
y <- trunc(runif(20,max=4))
id <- gl(4,5)
age <- rpois(20,20)
times <- rep(1:5,4)
logitord(y, id=id, out.ccov=~age, drop.ccov=age, pout=c(1,0,0),
	pdrop=c(1,0))
logitord(y, id, tvcov=times, pout=c(1,0,0), pdrop=c(1,0))
}
