% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addEnrichmentsLinkouts}
\alias{addEnrichmentsLinkouts}
\title{Add linkouts to external resources in the enrichments table}
\usage{
addEnrichmentsLinkouts(study, enrichmentsLinkouts, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{enrichmentsLinkouts}{The URL patterns that describe linkouts to
external resources (see Details below). The input object is a named list.
The names of the list correspond to the annotation names. Each element of
the list is a character vector of linkouts for that annotationID.}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\value{
Returns the original \code{onStudy} object passed to the argument
\code{study}, but modified to include the newly added data
}
\description{
You can provide additional information on the annotation terms in your study
by providing linkouts to external resources. These will be embedded directly
in the enrichments table.
}
\details{
For each linkout, the URL pattern you provide will be concatenated with the
value of the termID column. As an example, if you used the annotation
database \href{https://amigo.geneontology.org/}{AmiGO 2} for your enrichments
analysis, you can provide a linkout for each termID using the following
pattern:

\preformatted{go = "https://amigo.geneontology.org/amigo/term/"}

As another example, if you used the annotation database
\href{https://reactome.org/}{Reactome} for your enrichments analysis, you can
provide a linkout for each termID using the following pattern:

\preformatted{reactome = "https://reactome.org/content/detail/"}

Note that you can provide more than one linkout per termID.
}
\examples{
  study <- createStudy("example")
  enrichmentsLinkouts <- list(
    gobp = c("https://amigo.geneontology.org/amigo/term/",
             "https://www.ebi.ac.uk/QuickGO/term/"),
    reactome = "https://reactome.org/content/detail/"
  )
  study <- addEnrichmentsLinkouts(study, enrichmentsLinkouts)

}
\seealso{
\code{\link{getEnrichmentsLinkouts}},
\code{\link{addAnnotations}},
\code{\link{addEnrichments}}
}
