## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 7
)
set.seed(123)

## -----------------------------------------------------------------------------
library(OmicNetR)

## -----------------------------------------------------------------------------
omics_data <- generate_dummy_omics(
  n_samples = 60,
  n_genes = 800,
  n_metabolites = 150,
  n_linked = 20
)

X <- omics_data$X
Y <- omics_data$Y

## -----------------------------------------------------------------------------
aligned <- align_omics(X, Y)
X_aligned <- aligned$X
Y_aligned <- aligned$Y

## -----------------------------------------------------------------------------
scca_model <- omic_scca(
  X = X_aligned,
  Y = Y_aligned,
  n_components = 2,
  penalty_X = 0.70,
  penalty_Y = 0.70
)
str(scca_model, max.level = 1)

## -----------------------------------------------------------------------------
net_data <- scca_to_network(
  scca_model,
  comp_select = 1,
  weight_threshold = 0.01
)

# Keep the strongest edges for readability
net_data <- net_data[order(abs(net_data$Weight_Product), decreasing = TRUE), ]
net_data <- head(net_data, 50)
head(net_data)

## -----------------------------------------------------------------------------
plot_bipartite_network(net_data)

## -----------------------------------------------------------------------------
p <- plot_pathway_circle(scca_model, top_features = 30, pathway_db = "KEGG")
p

## -----------------------------------------------------------------------------
plot_correlation_heatmap(scca_model = scca_model, X = X_aligned, Y = Y_aligned, top_n = 25)

