% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{NCCTGLungCancer_df}
\alias{NCCTGLungCancer_df}
\title{NCCTG Lung Cancer Data}
\format{
A data frame with 228 observations and 10 variables:
\describe{
  \item{inst}{Institution code (numeric).}
  \item{time}{Survival time in days (numeric).}
  \item{status}{Survival status: 1 = dead, 2 = alive (numeric).}
  \item{age}{Age of the patient (numeric).}
  \item{sex}{Sex of the patient: 1 = male, 2 = female (numeric).}
  \item{ph.ecog}{ECOG performance score (numeric).}
  \item{ph.karno}{Karnofsky performance score (numeric).}
  \item{pat.karno}{Patient's Karnofsky performance score (numeric).}
  \item{meal.cal}{Daily calorie intake (numeric).}
  \item{wt.loss}{Weight loss in kilograms (numeric).}
}
}
\source{
Data taken from the nftbart package.
Based on survival data from patients with advanced lung cancer from the North Central Cancer Treatment Group (NCCTG).
Performance scores rate how well the patient can perform usual daily activities.
}
\usage{
data(NCCTGLungCancer_df)
}
\description{
This dataset, NCCTGLungCancer_df, is a data frame containing data on survival in patients with advanced lung cancer from the North Central Cancer Treatment Group (NCCTG). The data includes 228 observations and 10 variables related to clinical and performance score data for lung cancer patients.
}
\details{
The dataset name has been kept as 'NCCTGLungCancer_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
