% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{SmallCellLung_tbl_df}
\alias{SmallCellLung_tbl_df}
\title{Small Cell Lung Cancer Data}
\format{
A tibble with 121 observations and 3 variables:
\describe{
  \item{treatment}{Treatment group of the patient (factor with 2 levels).}
  \item{age}{Entry age of the patient at the start of treatment (integer).}
  \item{survival}{Survival time of the patient in days (integer).}
}
}
\source{
Data taken from the BSDA package. Originally published in:
Ying, Z., Jung, S., Wei, L. 1995. Survival Analysis with Median Regression Models.
}
\usage{
data(SmallCellLung_tbl_df)
}
\description{
This dataset, SmallCellLung_tbl_df, is a tibble containing information on the entry age
and survival time of 121 patients diagnosed with small cell lung cancer (SCLC) under two
different treatment regimens. The dataset provides key insights for survival analysis and
treatment comparisons in patients with SCLC.
}
\details{
The dataset name has been kept as 'SmallCellLung_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
OncoDataSets package and assists users in identifying its specific characteristics. The suffix
'tbl_df' indicates that the dataset is a tibble. The original content has not been modified in any way.
}
