% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{download_all}
\alias{download_all}
\title{Download all data alternative}
\usage{
download_all(
  file_path = NULL,
  s3_key_id = NULL,
  s3_secret_key = NULL,
  s3_region = NULL,
  s3_bucket = NULL,
  callback = NULL
)
}
\arguments{
\item{file_path}{location and name of the zip file to create.}

\item{s3_key_id}{A character string representing the AWS S3 access key ID.}

\item{s3_secret_key}{A character string representing the AWS S3 secret access key.}

\item{s3_region}{A character string representing the AWS S3 region.}

\item{s3_bucket}{A character string representing the AWS S3 bucket name.}

\item{callback}{Prints if the download was a success.}
}
\value{
Any return objects from the downloads.
}
\description{
This function allows users to download all data rather than one data set at a time.
}
\examples{
\dontrun{
    download_all_data <- download_all(file_path = "your/path/file.zip",
                                      s3_key_id = "your_s3_key_id",
                                      s3_secret_key = "your_s3_secret_key",
                                      s3_region = "your_s3_region",
                                      s3_bucket = "your_s3_bucket",
                                      callback = NULL)
}

}
