% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertMlrTaskToOMLDataSet.R
\name{convertMlrTaskToOMLDataSet}
\alias{convertMlrTaskToOMLDataSet}
\title{Converts a mlr task to an OpenML data set.}
\usage{
convertMlrTaskToOMLDataSet(task, description = NULL)
}
\arguments{
\item{task}{[\code{\link[mlr]{Task}}]\cr
A mlr task.}

\item{description}{[\code{character(1)}|\code{\link{OMLDataSetDescription}}]\cr
Either an \code{\link{OMLDataSetDescription}} or a \code{character(1)} that describes the data. 
For the latter, all other relevant information is autogenerated from the \code{\link[mlr]{Task}}.}
}
\value{
[\code{\link{OMLDataSet}}].
}
\description{
Converts a \code{\link[mlr]{Task}} to an \code{\link{OMLDataSet}}.
}
\seealso{
Other data set-related functions: 
\code{\link{OMLDataSetDescription}},
\code{\link{OMLDataSet}},
\code{\link{convertOMLDataSetToMlr}()},
\code{\link{deleteOMLObject}()},
\code{\link{getOMLDataSet}()},
\code{\link{listOMLDataSets}()},
\code{\link{tagOMLObject}()},
\code{\link{uploadOMLDataSet}()}
}
\concept{data set-related functions}
