% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_obwoe.R
\name{obwoe_min_bins}
\alias{obwoe_min_bins}
\title{Minimum Bins Parameter}
\usage{
obwoe_min_bins(range = c(2L, 5L), trans = NULL)
}
\arguments{
\item{range}{A two-element integer vector specifying the minimum and maximum
values for the parameter. Default is \code{c(2L, 5L)}.}

\item{trans}{A transformation object from the \code{scales} package, or
\code{NULL} for no transformation. Default is \code{NULL}.}
}
\value{
A \code{dials} quantitative parameter object.
}
\description{
A quantitative tuning parameter for the minimum number of bins in
\code{\link{step_obwoe}}.
}
\details{
The minimum number of bins constrains the algorithm to create at least
this many bins. Setting \code{min_bins = 2} allows maximum flexibility,
while higher values ensure more granular discretization.

For credit scoring applications, \code{min_bins} is typically set between
2 and 4 to avoid forcing artificial splits on weakly predictive variables.
}
\examples{
obwoe_min_bins()
obwoe_min_bins(range = c(3L, 7L))

}
\seealso{
\code{\link{step_obwoe}}, \code{\link{obwoe_max_bins}}
}
