% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitcher_traits.R
\docType{data}
\name{pitcher_traits}
\alias{pitcher_traits}
\title{Sample Multivariate Trait Data (Pitcher Plants)}
\format{
An object of class \code{data.frame} with 120 rows and 9 columns.
}
\usage{
pitcher_traits
}
\description{
These data represent a subset of trait information collected on carnivorous pitchers of the Northern Pitcher plant, *Sarracenia purpurea*,
across the species' native North American latitudinal range 30.197°N-53.722°N (Freedman et al. 2021).
We provide data from 5 sites out of the 36 sites sampled.
}
\details{
Pitcher traits measured include:

\itemize{
\item orthogonal rosette diameters: the length of the widest part of the basal rosette and the longest length of the basal rosette that is perpendicular to the length of the widest part of the basal rosette
\item pitcher length: for the randomly selected pitcher selected for measurement this represents the length from the base of the pitcher (near the rosette of the individual plant) up to the topmost part of the pitcher
\item pitcher width: length of the widest part of the pitcher randomly selected for measurement
\item keel width: length of the widest part of the keel (the lobe that runs from the pitcher opening to the base on the front side of the pitcher)
\item mouth diameter: the length of the widest part of the pitcher opening
\item lip thickness: the length of the thickness of the pitcher at its opening
}

See Ellison and Gotelli (2002) for a diagram illustrating traits measured.
}
\references{
Ellison, A.M., and N.J. Gotelli. 2002. Nitrogen availability alters the expression of carnivory in the Northern Pitcher Plant, *Sarracenia purpurea*. *Proceedings of the National Academy of Science* 99(7):4409-12.

Freedman, Z.B., A. McGrew, B. Baiser, M. Besson, D. Gravel, T. Poisot, S. Record, L.B. Trotta, and N.J. Gotelli. 2021. Environment-host-microbial interactions shape the *Sarracenia purpurea* microbiome at the continental scale. *Ecology*, 102(5):e03308.
}
\keyword{datasets}
