% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.sample.R
\name{trim.sample}
\alias{trim.sample}
\title{Trim a vector of numbers}
\usage{
trim.sample(x, trim = 0.01)
}
\arguments{
\item{x}{A numeric vector.}

\item{trim}{A number, the fraction of observations to be trimmed from each end of \code{x}.}
}
\value{
A sorted, trimmed copy of \code{x}.
}
\description{
Symmetrically trim a vector of numbers after sorting it.
}
\details{
If \code{length(x) <= 10}, the function returns \code{x[2:(length(x) - 1)]}.
}
\examples{
trim.sample(
    x = 1:20,
    trim = 0.01
    );
}
