% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NP_Graph.R
\name{NP_Graph}
\alias{NP_Graph}
\title{Estimation of network structure and variable selection in the nonlinear model with measurement errors in responses and covariates.}
\usage{
NP_Graph(
  W,
  Z,
  sigma_eta,
  rho,
  sigma_delta = 0.5,
  r = 0.8,
  lambda = 1,
  pi = 0.8,
  label_name,
  var_thred = 5
)
}
\arguments{
\item{W}{A n × m response matrix. The variables can be error-prone or precisely measured, and can include continuous, binary, or count random variables.}

\item{Z}{A n × p matrix of continuous covariates. The variables can be error-prone or precisely measured.}

\item{sigma_eta}{A p × p covariance matrix of the noise term \eqn{\eta} in the classical measurement error model Z = X + \eqn{\eta}, where X is the unobserved version of Z.}

\item{rho}{A tuning parameter for the graphical lasso.}

\item{sigma_delta}{The common value in the diagonal covariance matrix of the noise term \eqn{\delta} in the classical measurement error model for continuous components in W. The default value is 0.5.}

\item{r}{A probability r for misclassification when components in W are binary. The default value is 0.8.}

\item{lambda}{A parameter \eqn{\lambda} in the Poisson distribution that provides the increasing measurement error effects when components in W are count. The default value is 1.}

\item{pi}{A parameter \eqn{\pi} in [0,1] for the Binomial distribution that characterizes the decreasing measurement error effects when components in W are count. The default value is 0.8.}

\item{label_name}{The name of the response variable. The default value is TRUE, which reflects the labels from the input data. Else, users can input the required labels manually.}

\item{var_thred}{A positive value used to retain important covariates. That is, covariates will be selected when refitting the model if their importance scores are greater than var_thred. The default value is 5.}
}
\value{
\item{W_hat}{The n × m matrix of corrected responses determined by regression calibration.}
  \item{Z_hat}{The n × p matrix of corrected covariates determined by regression calibration..}
  \item{PSE}{The Frobenius norm of the residual corresponding to W_hat.}
  \item{importance_score}{A matrix containing importance scores for the covariates.}
  \item{precision_matrix}{An estimated matrix reflecting the network structure of the responses.}
  \item{graph}{An visualization of the estimated network structure by \code{precision_matrix}.}
}
\description{
This function characterizes Y and X by nonlinear models and is designed for detecting network structure and variable selection with measurement error in responses and covariates. Here the components of Y can be continuous, binary, or count. The estimation strategy in this function includes the regression calibration for correcting error-prone responses and covariates, the random forest method for marginally characterizing the response and covariates, and the distance correlation and graphical lasso for detecting the network structure among the responses.
}
\examples{
n <- 100
Z <- matrix(rnorm(n * 10), n, 10)
W <- matrix(rnorm(n * 5), n, 5)
sigma_eta <- diag(0.15, ncol(Z))

NP_Graph(W, Z, sigma_eta, rho = 0.2,
                   sigma_delta = 0.5, r = 0.8,
                   lambda = 1, pi = 0.8,
                   label_name = TRUE, var_thred = 3)

}
\author{
Wan-Yi Chang and Li-Pang Chen \cr
Maintainer: Wan-Yi Chang \email{jessica306a@gmail.com}
}
