% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleheatmap.R
\name{multipleheatmap}
\alias{multipleheatmap}
\title{multipleheatmap}
\usage{
multipleheatmap(data, demography, f, category = TRUE)
}
\arguments{
\item{data}{Combined csv file from SenseWear with multiple participants, participants are distinguished by ID. Refer to sampledata_multiple.rda for sample format.}

\item{demography}{Demographic data includes the required factor(s) (e.g. age and/or gender) of the corresponding participant.}

\item{f}{The factor (age, gender, etc.) user wants to group data by.}

\item{category}{TRUE or FALSE for categorical factor. Default is TRUE.}
}
\value{
\code{Graph}	A heatmap generated by ggplot with x axis Time and y axis factor.

\code{Table} A table summarizes the number of records of each participant on each day.
}
\description{
Generate heatmap to show activity intensity (in MET) of multiple participants grouped by specified factor (age, gender, etc.).
}
\details{
The mean of METs of available days/groups are calculated and used in the heatmap.
}
\examples{
# Continuous factor example
multipleheatmap(sampledata_multiple,demography,Age,category=FALSE)
# Categorical factor example
multipleheatmap(sampledata_multiple,demography,Gender,category=TRUE)
}

