% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ba_analysis.R
\name{ba_analysis}
\alias{ba_analysis}
\title{Perform Bland-Altman analysis on a data frame}
\usage{
ba_analysis(df, x_var, y_var, regress_against = c("Y", "XY_mean"), ...)
}
\arguments{
\item{df}{the data frame on which to operate}

\item{x_var}{character. The column name of the X variable}

\item{y_var}{character. The column name of the Y variable (criterion measure,
if applicable)}

\item{regress_against}{character. One of \code{"Y"} (to regress bias
against \code{yvar}) or \code{"XY_mean"} (to regress bias against
\code{rowMeans(x_var, y_var)}).}

\item{...}{optional arguments passed to \code{data.frame}, e.g. to give the
output results a label}
}
\value{
A data frame that has various summaries (means, standard deviations,
  and missing data details) plus mean bias (\code{mean_bias} column) and
  limits of agreement (\code{lower_LOA} and \code{upper_LOA} columns)
}
\description{
Perform Bland-Altman analysis on a data frame
}
\examples{
data(ex_data, package = "PAutilities")
ba_analysis(ex_data, "Axis1", "Vector.Magnitude", "XY_mean")
ba_analysis(
  ex_data, "Axis1", "Vector.Magnitude", "XY_mean",
  an_arbitrary_added_column = "Example of passing an extra column"
)
}
