% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeListAllPartitions}
\alias{PCMTreeListAllPartitions}
\title{A list of all possible (including recursive) partitions of a tree}
\usage{
PCMTreeListAllPartitions(
  tree,
  minCladeSize,
  skipNodes = character(),
  tableAncestors = NULL,
  verbose = FALSE
)
}
\arguments{
\item{tree}{a phylo object with set labels for the internal nodes}

\item{minCladeSize}{integer indicating the minimum number of tips allowed in
one part.}

\item{skipNodes}{an integer or character vector indicating the ids or labels
of nodes that should not be used as partition nodes. By default, this is an
empty character vector.}

\item{tableAncestors}{NULL (default) or an integer matrix returned by a
previous call to \code{PCMTreeTableAncestors(tree)}.}

\item{verbose}{a logical indicating if informative messages should be printed to
the console.}
}
\value{
a list of integer vectors.
}
\description{
A list of all possible (including recursive) partitions of a tree
}
\examples{

set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
tree <- PCMTree(ape::rtree(10))

if(requireNamespace("ggtree"))
PCMTreePlot(tree) + ggtree::geom_nodelab() + ggtree::geom_tiplab()

# list of all partitions into parts of at least 4 tips
PCMTreeListAllPartitions(tree, 4)

# list of all partitions into parts of at least 3 tips
PCMTreeListAllPartitions(tree, 3)

# list all partitions into parts of at least 3 tips, excluding the partitions
# where node 16 is one of the partition nodes:
PCMTreeListAllPartitions(tree, minCladeSize = 3, skipNodes = "16")

}
