% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMRS-package.R
\docType{data}
\name{emotion}
\alias{emotion}
\title{Emotional reactivity data from the Freiburg Complaint Checklist (emotion)}
\format{
A data frame containing data from the Freiburg Complaint Checklist with 2032 observations. 
All items refer to the scale \emph{Emotional reactivity} and are measured on a 5-point Likert scale where low numbers 
correspond to low frequencies or low intensitites of the respective complaint and vice versa. 
\describe{ 
\item{Feel upset in whole body}{Do you feel it in the whole body when you get upset about something?}
\item{Eyes well up with tears}{Do your eyes well up with tears in certain situations?}
\item{Stammer}{Do you sometimes start stammering in certain situations?}
\item{Blush}{Do you blush?}
\item{Gasp for air}{Do you have to gasp for air in exciting situations, so that you have to take a deep breath?}
\item{Rapid heartbeat in excitement}{Do you feel a rapid heartbeat in excitement?}
\item{Urge to defecate in excitement}{Do you feel the urge to defecate in excitement?}
\item{Trembling knees}{Do you start trembling in excitement or do you get trembling knees?}
 }
}
\source{
ZPID (2013). PsychData of the Leibniz Institute for Psychology Information ZPID. Trier: Center for Research Data in Psychology.

Fahrenberg, J. (2010). Freiburg Complaint Checklist [Freiburger Beschwerdenliste (FBL)]. Goettingen, Hogrefe.
}
\description{
Data from the Freiburg Complaint Checklist. 
The data contain all 8 items corresponding to the scale \emph{Emotional reactivity} for 2032 participants of the 
standardization sample of the Freiburg Complaint Checklist.
}
\examples{
\dontrun{
data(emotion)
m.emotion <- PCMRS(emotion)
m.emotion

plot(m.emotion)
}
}
\references{
Tutz, Gerhard, Schauberger, Gunther and Berger, Moritz (2018): 
Response Styles in the Partial Credit Model, \emph{Applied Psychological Measurement}, \doi{10.1177/0146621617748322}
}
\keyword{datasets}
